/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.net;

import fr.jayasoft.ivy.ant.IvyCacheFileset;
import fr.jayasoft.ivy.ant.IvyConfigure;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.ImportTask;
import org.apache.tools.ant.types.FileSet;

public class URLImportTask
extends ImportTask {
    private String org;
    private String module;
    private String rev = "latest.integration";
    private String conf = "default";
    private String type = "jar";
    private String repositoryUrl;
    private File repositoryDir;
    private URL ivyConfUrl;
    private File ivyConfFile;
    private String resource = "build.xml";
    private String artifactPattern = "/[org]/[module]/[ext]s/[module]-[revision].[ext]";
    private String ivyPattern = "/[org]/[module]/ivy-[revision].xml";

    public void setModule(String module) {
        this.module = module;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public void setConf(String conf) {
        this.conf = conf;
    }

    public void setIvyConfFile(File ivyConfFile) {
        this.ivyConfFile = ivyConfFile;
    }

    public void setIvyConfUrl(URL ivyConfUrl) {
        this.ivyConfUrl = ivyConfUrl;
    }

    public void setArtifactPattern(String artifactPattern) {
        this.artifactPattern = artifactPattern;
    }

    public void setIvyPattern(String ivyPattern) {
        this.ivyPattern = ivyPattern;
    }

    public void setRepositoryDir(File repositoryDir) {
        this.repositoryDir = repositoryDir;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setOptional(boolean optional) {
        throw new BuildException("'optional' property not accessed for ImportURL.");
    }

    public void setFile(String file) {
        throw new BuildException("'file' property not accessed for ImportURL.");
    }

    public void execute() throws BuildException {
        IvyConfigure configure = new IvyConfigure();
        configure.setProject(this.getProject());
        configure.setLocation(this.getLocation());
        configure.setOwningTarget(this.getOwningTarget());
        configure.setTaskName(this.getTaskName());
        configure.init();
        if (this.ivyConfUrl != null) {
            if (this.ivyConfUrl.getProtocol().equalsIgnoreCase("file")) {
                String path = this.ivyConfUrl.getPath();
                File f = new File(path);
                if (!f.isAbsolute()) {
                    f = new File(this.getProject().getBaseDir(), path);
                }
                configure.setFile(f);
            } else {
                try {
                    configure.setUrl(this.ivyConfUrl.toExternalForm());
                }
                catch (MalformedURLException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        } else if (this.ivyConfFile != null) {
            configure.setFile(this.ivyConfFile);
        } else if (this.repositoryDir != null || this.repositoryUrl != null) {
            File temp = null;
            OutputStreamWriter fw = null;
            try {
                temp = File.createTempFile("ivyconf", ".xml");
                temp.deleteOnExit();
                fw = new FileWriter(temp);
                fw.write("<ivyconf>");
                fw.write("<conf defaultResolver=\"default\" />");
                fw.write("<resolvers>");
                if (this.repositoryDir != null) {
                    fw.write("<filesystem name=\"default\">");
                    fw.write("<ivy pattern=\"" + this.repositoryDir + "/" + this.ivyPattern + "\"  />");
                    fw.write("<artifact pattern=\"" + this.repositoryDir + "/" + this.artifactPattern + "\"  />");
                    fw.write("</filesystem>");
                } else {
                    fw.write("<url name=\"default\">");
                    fw.write("<ivy pattern=\"" + this.repositoryUrl + "/" + this.ivyPattern + "\"  />");
                    fw.write("<artifact pattern=\"" + this.repositoryUrl + "/" + this.artifactPattern + "\"  />");
                    fw.write("</url>");
                }
                fw.write("</resolvers>");
                fw.write("<latest-strategies>");
                fw.write("<latest-revision name=\"latest\"/>");
                fw.write("</latest-strategies>");
                fw.write("</ivyconf>");
                fw.close();
                fw = null;
                configure.setFile(temp);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            finally {
                try {
                    if (fw != null) {
                        fw.close();
                        fw = null;
                    }
                }
                catch (IOException e) {}
            }
        }
        configure.execute();
        IvyCacheFileset cacheFileSet = new IvyCacheFileset();
        cacheFileSet.setProject(this.getProject());
        cacheFileSet.setLocation(this.getLocation());
        cacheFileSet.setOwningTarget(this.getOwningTarget());
        cacheFileSet.setTaskName(this.getTaskName());
        cacheFileSet.setInline(true);
        cacheFileSet.setOrganisation(this.org);
        cacheFileSet.setModule(this.module);
        cacheFileSet.setRevision(this.rev);
        cacheFileSet.setConf(this.conf);
        cacheFileSet.init();
        cacheFileSet.setSetid(this.org + this.module + this.rev + ".fileset");
        cacheFileSet.execute();
        FileSet fileset = (FileSet)this.getProject().getReference(this.org + this.module + this.rev + ".fileset");
        DirectoryScanner scanner = fileset.getDirectoryScanner(this.getProject());
        String[] files = scanner.getIncludedFiles();
        File file = new File(scanner.getBasedir(), files[0]);
        File importFile = null;
        if ("xml".equalsIgnoreCase(this.type)) {
            importFile = file;
        } else if ("jar".equalsIgnoreCase(this.type) || "zip".equalsIgnoreCase(this.type)) {
            File dir = new File(file.getParentFile(), file.getName() + ".extracted");
            if (!dir.exists() || dir.lastModified() < file.lastModified()) {
                dir.mkdir();
                Expand expand = (Expand)this.getProject().createTask("unjar");
                expand.setSrc(file);
                expand.setDest(dir);
                expand.perform();
            }
            if (!(importFile = new File(dir, this.resource)).exists()) {
                throw new BuildException("Cannot find a '" + this.resource + "' file in " + file.getName());
            }
        } else {
            throw new BuildException("Don't know what to do with type: " + this.type);
        }
        this.log("Importing " + importFile.getName(), 2);
        super.setFile(importFile.getAbsolutePath());
        super.execute();
        this.log("Import complete.", 2);
    }
}

