/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Log
extends SvnCommand {
    private File destFile = null;
    private SVNUrl url = null;
    private File path = null;
    private boolean stopOnCopy = true;
    private boolean asXml = true;
    private long limit = 0L;
    private SVNRevision startRevision = SVNRevision.HEAD;
    private SVNRevision stopRevision = new SVNRevision.Number(1L);

    public void execute() throws SvnAntException {
        ISVNLogMessage[] iSVNLogMessageArray = null;
        try {
            iSVNLogMessageArray = this.path != null ? this.svnClient.getLogMessages(this.path, this.startRevision, this.stopRevision, this.stopOnCopy, false, this.limit) : this.svnClient.getLogMessages(this.url, this.startRevision, this.startRevision, this.stopRevision, this.stopOnCopy, false, this.limit);
            this.writeLogMessages(iSVNLogMessageArray);
        }
        catch (Exception exception) {
            throw new SvnAntException("Can't get the log messages for the path or url", exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeLogMessages(ISVNLogMessage[] iSVNLogMessageArray) throws SvnAntException {
        BufferedWriter bufferedWriter = null;
        try {
            try {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.destFile)));
                if (this.asXml) {
                    this.writeXmlHeader(bufferedWriter);
                    for (int i = 0; i < iSVNLogMessageArray.length; ++i) {
                        this.writeLogEntryAsXml(iSVNLogMessageArray[i], bufferedWriter);
                    }
                    this.writeXmlFooter(bufferedWriter);
                } else {
                    for (int i = 0; i < iSVNLogMessageArray.length; ++i) {
                        this.writeLogEntryAsPlaintext(iSVNLogMessageArray[i], bufferedWriter);
                    }
                }
                Object var5_6 = null;
                if (bufferedWriter == null) return;
            }
            catch (Exception exception) {
                throw new SvnAntException("Can't get the content of the specified file", exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (bufferedWriter == null) throw throwable;
            try {
                bufferedWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedWriter.close();
        return;
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.url == null && this.path == null) {
            throw new SvnAntValidationException("url or path attributes must be set");
        }
        if (this.destFile == null) {
            this.destFile = new File(this.getProject().getBaseDir(), this.url.getLastPathSegment());
        }
        if (this.startRevision == null) {
            throw SvnAntValidationException.createInvalidRevisionException();
        }
        if (this.stopRevision == null) {
            throw SvnAntValidationException.createInvalidRevisionException();
        }
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setDestFile(File file) {
        this.destFile = file;
    }

    public void setStartRevision(String string) {
        this.startRevision = this.getRevisionFrom(string);
    }

    public void setStopRevision(String string) {
        this.stopRevision = this.getRevisionFrom(string);
    }

    public void setStopOnCopy(boolean bl) {
        this.stopOnCopy = bl;
    }

    public void setAsXml(boolean bl) {
        this.asXml = bl;
    }

    public void setLimit(int n) {
        this.limit = n;
    }

    private void writeLogEntryAsPlaintext(ISVNLogMessage iSVNLogMessage, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("------------------------------------------------------------------------");
        bufferedWriter.newLine();
        bufferedWriter.write(114);
        bufferedWriter.write(iSVNLogMessage.getRevision().toString());
        bufferedWriter.write(" | ");
        bufferedWriter.write(iSVNLogMessage.getAuthor());
        bufferedWriter.write(" | ");
        bufferedWriter.write(iSVNLogMessage.getDate().toString());
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        bufferedWriter.write(iSVNLogMessage.getMessage());
        bufferedWriter.newLine();
    }

    private void writeLogEntryAsXml(ISVNLogMessage iSVNLogMessage, BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<logentry revision=\"");
        bufferedWriter.write(iSVNLogMessage.getRevision().toString());
        bufferedWriter.write("\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<author>");
        bufferedWriter.write(iSVNLogMessage.getAuthor());
        bufferedWriter.write("</author>");
        bufferedWriter.newLine();
        bufferedWriter.write("<date>");
        bufferedWriter.write(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(iSVNLogMessage.getDate()));
        bufferedWriter.write("</date>");
        bufferedWriter.newLine();
        bufferedWriter.write("<msg>");
        bufferedWriter.write(iSVNLogMessage.getMessage());
        bufferedWriter.write("</msg>");
        bufferedWriter.newLine();
        bufferedWriter.write("</logentry>");
        bufferedWriter.newLine();
    }

    private void writeXmlHeader(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        bufferedWriter.newLine();
        bufferedWriter.write("<log>");
        bufferedWriter.newLine();
    }

    private void writeXmlFooter(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("</log>");
    }
}

