/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.ant;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.engine.BaseRenderEngine;
import org.radeox.engine.context.BaseRenderContext;

public class RadeoxAntTask
extends Task {
    private String m_inputFile;
    private String m_outputFile;
    private boolean m_verbose = false;

    public void setVerbose(boolean b) {
        this.m_verbose = b;
    }

    public void setInputFile(String file) {
        this.m_inputFile = file;
    }

    public void setOutputFile(String file) {
        this.m_outputFile = file;
    }

    public void execute() throws BuildException {
        if (this.m_inputFile == null) {
            throw new BuildException("InputFile not specified");
        }
        if (this.m_outputFile == null) {
            throw new BuildException("OutputFile not specified");
        }
        BaseRenderEngine engine = new BaseRenderEngine();
        BaseRenderContext context = new BaseRenderContext();
        BufferedReader reader = null;
        Writer writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.m_inputFile)));
            writer = new OutputStreamWriter(new FileOutputStream(this.m_outputFile));
            if (this.m_verbose) {
                this.log(this.m_inputFile + " => " + this.m_outputFile);
            }
            String line = null;
            while ((line = reader.readLine()) != null) {
                String out = engine.render(line, (RenderContext)context);
                if (this.m_verbose) {
                    this.log(out != null ? out : "null");
                }
                writer.write(out);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

