/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.SpecificLongValue;
import proguard.evaluation.value.ValueFactory;

final class SpecificIntegerValue
extends IntegerValue {
    private final int value;

    public SpecificIntegerValue(int n) {
        this.value = n;
    }

    public int value() {
        return this.value;
    }

    public IntegerValue generalize(IntegerValue integerValue) {
        return integerValue.generalize(this);
    }

    public IntegerValue add(IntegerValue integerValue) {
        return integerValue.add(this);
    }

    public IntegerValue subtract(IntegerValue integerValue) {
        return integerValue.subtractFrom(this);
    }

    public IntegerValue subtractFrom(IntegerValue integerValue) {
        return integerValue.subtract(this);
    }

    public IntegerValue multiply(IntegerValue integerValue) {
        return integerValue.multiply(this);
    }

    public IntegerValue divide(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.divideOf(this);
    }

    public IntegerValue divideOf(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.divide(this);
    }

    public IntegerValue remainder(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.remainderOf(this);
    }

    public IntegerValue remainderOf(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.remainder(this);
    }

    public IntegerValue shiftLeft(IntegerValue integerValue) {
        return integerValue.shiftLeftOf(this);
    }

    public IntegerValue shiftLeftOf(IntegerValue integerValue) {
        return integerValue.shiftLeft(this);
    }

    public IntegerValue shiftRight(IntegerValue integerValue) {
        return integerValue.shiftRightOf(this);
    }

    public IntegerValue shiftRightOf(IntegerValue integerValue) {
        return integerValue.shiftRight(this);
    }

    public IntegerValue unsignedShiftRight(IntegerValue integerValue) {
        return integerValue.unsignedShiftRightOf(this);
    }

    public IntegerValue unsignedShiftRightOf(IntegerValue integerValue) {
        return integerValue.unsignedShiftRight(this);
    }

    public LongValue shiftLeftOf(LongValue longValue) {
        return longValue.shiftLeft(this);
    }

    public LongValue shiftRightOf(LongValue longValue) {
        return longValue.shiftRight(this);
    }

    public LongValue unsignedShiftRightOf(LongValue longValue) {
        return longValue.unsignedShiftRight(this);
    }

    public IntegerValue and(IntegerValue integerValue) {
        return integerValue.and(this);
    }

    public IntegerValue or(IntegerValue integerValue) {
        return integerValue.or(this);
    }

    public IntegerValue xor(IntegerValue integerValue) {
        return integerValue.xor(this);
    }

    public int equal(IntegerValue integerValue) {
        return integerValue.equal(this);
    }

    public int lessThan(IntegerValue integerValue) {
        return integerValue.greaterThan(this);
    }

    public int lessThanOrEqual(IntegerValue integerValue) {
        return integerValue.greaterThanOrEqual(this);
    }

    public IntegerValue negate() {
        return new SpecificIntegerValue(-this.value);
    }

    public IntegerValue convertToByte(ValueFactory valueFactory) {
        byte by = (byte)this.value;
        return by == this.value ? this : new SpecificIntegerValue(by);
    }

    public IntegerValue convertToCharacter(ValueFactory valueFactory) {
        char c = (char)this.value;
        return c == this.value ? this : new SpecificIntegerValue(c);
    }

    public IntegerValue convertToShort(ValueFactory valueFactory) {
        short s = (short)this.value;
        return s == this.value ? this : new SpecificIntegerValue(s);
    }

    public IntegerValue convertToInteger(ValueFactory valueFactory) {
        return this;
    }

    public LongValue convertToLong(ValueFactory valueFactory) {
        return valueFactory.createLongValue(this.value);
    }

    public FloatValue convertToFloat(ValueFactory valueFactory) {
        return valueFactory.createFloatValue(this.value);
    }

    public DoubleValue convertToDouble(ValueFactory valueFactory) {
        return valueFactory.createDoubleValue(this.value);
    }

    public IntegerValue generalize(SpecificIntegerValue specificIntegerValue) {
        return this.value == specificIntegerValue.value ? this : ValueFactory.INTEGER_VALUE;
    }

    public IntegerValue add(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(this.value + specificIntegerValue.value);
    }

    public IntegerValue subtract(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(this.value - specificIntegerValue.value);
    }

    public IntegerValue subtractFrom(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(specificIntegerValue.value - this.value);
    }

    public IntegerValue multiply(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(this.value * specificIntegerValue.value);
    }

    public IntegerValue divide(SpecificIntegerValue specificIntegerValue) throws ArithmeticException {
        return new SpecificIntegerValue(this.value / specificIntegerValue.value);
    }

    public IntegerValue divideOf(SpecificIntegerValue specificIntegerValue) throws ArithmeticException {
        return new SpecificIntegerValue(specificIntegerValue.value / this.value);
    }

    public IntegerValue remainder(SpecificIntegerValue specificIntegerValue) throws ArithmeticException {
        return new SpecificIntegerValue(this.value % specificIntegerValue.value);
    }

    public IntegerValue remainderOf(SpecificIntegerValue specificIntegerValue) throws ArithmeticException {
        return new SpecificIntegerValue(specificIntegerValue.value % this.value);
    }

    public IntegerValue shiftLeft(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(this.value << specificIntegerValue.value);
    }

    public IntegerValue shiftLeftOf(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(specificIntegerValue.value << this.value);
    }

    public IntegerValue shiftRight(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(this.value >> specificIntegerValue.value);
    }

    public IntegerValue shiftRightOf(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(specificIntegerValue.value >> this.value);
    }

    public IntegerValue unsignedShiftRight(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(this.value >>> specificIntegerValue.value);
    }

    public IntegerValue unsignedShiftRightOf(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(specificIntegerValue.value >>> this.value);
    }

    public LongValue shiftLeftOf(SpecificLongValue specificLongValue, ValueFactory valueFactory) {
        return valueFactory.createLongValue(specificLongValue.value() << this.value);
    }

    public LongValue shiftRightOf(SpecificLongValue specificLongValue, ValueFactory valueFactory) {
        return valueFactory.createLongValue(specificLongValue.value() >> this.value);
    }

    public LongValue unsignedShiftRightOf(SpecificLongValue specificLongValue, ValueFactory valueFactory) {
        return valueFactory.createLongValue(specificLongValue.value() >>> this.value);
    }

    public IntegerValue and(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(this.value & specificIntegerValue.value);
    }

    public IntegerValue or(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(this.value | specificIntegerValue.value);
    }

    public IntegerValue xor(SpecificIntegerValue specificIntegerValue) {
        return new SpecificIntegerValue(this.value ^ specificIntegerValue.value);
    }

    public int equal(SpecificIntegerValue specificIntegerValue) {
        return this.value == specificIntegerValue.value ? 1 : -1;
    }

    public int lessThan(SpecificIntegerValue specificIntegerValue) {
        return this.value < specificIntegerValue.value ? 1 : -1;
    }

    public int lessThanOrEqual(SpecificIntegerValue specificIntegerValue) {
        return this.value <= specificIntegerValue.value ? 1 : -1;
    }

    public boolean isSpecific() {
        return true;
    }

    public boolean equals(Object object) {
        return object != null && this.getClass() == object.getClass() && this.value == ((SpecificIntegerValue)object).value;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.value;
    }

    public String toString() {
        return "i:" + this.value;
    }
}

