/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;

public class ClassOpener
extends SimplifiedVisitor
implements ConstantVisitor {
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.fixPackageVisibility(clazz, stringConstant.referencedClass, stringConstant.referencedMember);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.fixPackageVisibility(clazz, refConstant.referencedClass, refConstant.referencedMember);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        int n;
        Clazz clazz2 = classConstant.referencedClass;
        if (clazz2 != null && this.isNotPublic(n = clazz2.getAccessFlags()) && clazz2 instanceof ProgramClass && this.inDifferentPackages(clazz, clazz2)) {
            ((ProgramClass)clazz2).u2accessFlags = AccessUtil.replaceAccessFlags(n, 1);
        }
    }

    private void fixPackageVisibility(Clazz clazz, Clazz clazz2, Member member) {
        int n;
        if (member != null && this.isNotPublic(n = member.getAccessFlags()) && member instanceof ProgramMember && this.inDifferentPackages(clazz, clazz2)) {
            ((ProgramMember)member).u2accessFlags = AccessUtil.replaceAccessFlags(n, clazz.extends_(clazz2) ? 4 : 1);
        }
    }

    private boolean inDifferentPackages(Clazz clazz, Clazz clazz2) {
        return !ClassUtil.internalPackageName(clazz.getName()).equals(ClassUtil.internalPackageName(clazz2.getName()));
    }

    private boolean isNotPublic(int n) {
        return (n & 1) == 0;
    }
}

