/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

final class ShortestUsageMark {
    private final boolean certain;
    private final String reason;
    private final int depth;
    private Clazz clazz;
    private Method method;

    public ShortestUsageMark(String string) {
        this.certain = true;
        this.reason = string;
        this.depth = 0;
    }

    public ShortestUsageMark(ShortestUsageMark shortestUsageMark, String string, int n, Clazz clazz) {
        this(shortestUsageMark, string, n, clazz, null);
    }

    public ShortestUsageMark(ShortestUsageMark shortestUsageMark, String string, int n, Clazz clazz, Method method) {
        this.certain = true;
        this.reason = string;
        this.depth = shortestUsageMark.depth + n;
        this.clazz = clazz;
        this.method = method;
    }

    public ShortestUsageMark(ShortestUsageMark shortestUsageMark, boolean bl) {
        this.certain = bl;
        this.reason = shortestUsageMark.reason;
        this.depth = shortestUsageMark.depth;
        this.clazz = shortestUsageMark.clazz;
        this.method = shortestUsageMark.method;
    }

    public boolean isCertain() {
        return this.certain;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isShorter(ShortestUsageMark shortestUsageMark) {
        return this.depth < shortestUsageMark.depth;
    }

    public boolean isCausedBy(Clazz clazz) {
        return clazz.equals(this.clazz);
    }

    public void acceptClassVisitor(ClassVisitor classVisitor) {
        if (this.clazz != null && this.method == null) {
            this.clazz.accept(classVisitor);
        }
    }

    public void acceptMethodVisitor(MemberVisitor memberVisitor) {
        if (this.clazz != null && this.method != null) {
            this.method.accept(this.clazz, memberVisitor);
        }
    }

    public String toString() {
        return "certain=" + this.certain + ", depth=" + this.depth + ": " + this.reason + (this.clazz != null ? this.clazz.getName() : "(none)") + ": " + (this.method != null ? this.method.getName(this.clazz) : "(none)");
    }
}

