/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.radeox.macro.LocalePreserved;
import org.radeox.macro.parameter.MacroParameter;
import org.radeox.util.i18n.ResourceManager;

public class QuoteMacro
extends LocalePreserved {
    private static Log log = LogFactory.getLog(QuoteMacro.class);

    public String getLocaleKey() {
        return "macro.quote";
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        String sourceDesc;
        writer.write("<blockquote class=\"quote\">");
        writer.write(params.getContent());
        try {
            sourceDesc = ResourceManager.getString((String)this.initialContext.get("RenderContext.language_bundle_name"), this.getLocaleKey() + ".source");
        }
        catch (Exception e) {
            log.warn("missing value for " + this.getLocaleKey() + ".source");
            sourceDesc = "Source";
        }
        if (params.getLength() > 0) {
            String source = params.get(0);
            boolean isLink = source.toLowerCase().startsWith("http://");
            if (params.getLength() == 2) {
                sourceDesc = params.get(1);
            }
            if (isLink) {
                writer.write("<br><a href=\"" + source + "\">");
                writer.write(sourceDesc);
                writer.write("</a>");
            } else {
                writer.write("<br><b>" + source + "</b>");
            }
        }
        writer.write("</blockquote>");
    }
}

