/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v1;

import antenna.preprocessor.IPreprocessor;
import antenna.preprocessor.PreprocessorException;
import antenna.preprocessor.v1.BooleanEvaluator;
import antenna.preprocessor.v1.PreprocessorLine;
import antenna.preprocessor.v2.PPException;
import de.pleumann.antenna.misc.Strings;
import de.pleumann.antenna.misc.Utility;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public class Preprocessor
implements IPreprocessor {
    private static final int STATE_NO_CONDITIONAL = 0;
    private static final int STATE_CAN_BECOME_TRUE = 1;
    private static final int STATE_IS_TRUE = 2;
    private static final int STATE_HAS_BEEN_TRUE = 3;
    private BooleanEvaluator eval = new BooleanEvaluator("");
    private Stack stack = new Stack();
    private int state;
    private int mode = 0;
    private File file;
    private String packageName;
    private PreprocessorLine pl;
    private int currentLine;
    private Utility utility;
    private String encoding;

    public Preprocessor(Utility utility, String encoding) {
        this.utility = utility;
        this.encoding = encoding;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public boolean isBlind() {
        return (this.state == 1 || this.state == 3) && this.mode != 2;
    }

    public String getPackageName() {
        return this.packageName;
    }

    private void pushState() {
        this.stack.push(new Integer(this.state));
    }

    private void popState() {
        this.state = (Integer)this.stack.pop();
    }

    private void handleIf(boolean condition) {
        this.pushState();
        this.state = !this.isBlind() ? (condition ? 2 : 1) : 3;
    }

    private void handleElseIf(boolean condition) throws PreprocessorException {
        if (this.state == 0) {
            throw new PreprocessorException("Unexpected #elif", this.file, this.currentLine);
        }
        if (this.state == 1) {
            if (condition) {
                this.state = 2;
            }
        } else if (this.state == 2) {
            this.state = 3;
        }
    }

    private void handleElse() throws PreprocessorException {
        if (this.state == 0) {
            throw new PreprocessorException("Unexpected #else", this.file, this.currentLine);
        }
        if (this.state == 1) {
            this.state = 2;
        } else if (this.state == 2) {
            this.state = 3;
        }
    }

    private void handleEndIf() throws PreprocessorException {
        if (this.state == 0) {
            throw new PreprocessorException("Unexpected #endif", this.file, this.currentLine);
        }
        this.popState();
    }

    private void handleCommand(PreprocessorLine l) throws PreprocessorException {
        int type = l.getType();
        if (type == 2) {
            if (!this.isBlind()) {
                this.eval.define(l.getArgs());
            }
        } else if (type == 3) {
            if (!this.isBlind()) {
                this.eval.undefine(l.getArgs());
            }
        } else if (type == 10) {
            this.handleIf(this.eval.evaluate(l.getArgs()));
        } else if (type == 4) {
            this.handleIf(this.eval.isDefined(l.getArgs()));
        } else if (type == 5) {
            this.handleIf(!this.eval.isDefined(l.getArgs()));
        } else if (type == 11) {
            this.handleElseIf(this.eval.evaluate(l.getArgs()));
        } else if (type == 8) {
            this.handleElseIf(this.eval.isDefined(l.getArgs()));
        } else if (type == 9) {
            this.handleElseIf(!this.eval.isDefined(l.getArgs()));
        } else if (type == 6) {
            this.handleElse();
        } else if (type == 7) {
            this.handleEndIf();
        }
    }

    public void setMode(int value) {
        this.mode = value;
    }

    public String filterLine(String s) throws PreprocessorException {
        String t = this.utility.getProject().replaceProperties(s);
        if (!t.equals(s)) {
            int j;
            int i = t.indexOf("Integer.parseInt(\"");
            if (i != -1 && (j = t.indexOf("\")", i + 18)) != -1) {
                try {
                    int n = Integer.parseInt(t.substring(i + 18, j));
                    t = t.substring(0, i) + n + t.substring(j + 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((i = t.indexOf("\"true\".equals(\"")) != -1 && (j = t.indexOf("\")", i + 15)) != -1) {
                try {
                    boolean bl = "true".equals(t.substring(i + 15, j));
                    t = t.substring(0, i) + bl + t.substring(j + 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((i = t.indexOf("Double.parseDouble(\"")) != -1 && (j = t.indexOf("\")", i + 20)) != -1) {
                try {
                    double d = Double.parseDouble(t.substring(i + 20, j));
                    t = t.substring(0, i) + d + t.substring(j + 2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return t;
    }

    public PreprocessorLine analyzeLine(String s) throws PreprocessorException {
        if (this.pl == null) {
            this.pl = new PreprocessorLine(s);
        } else {
            this.pl.processLine(s);
        }
        return this.pl;
    }

    String commentLine(PreprocessorLine l) {
        if ((this.mode & 0x80) == 0) {
            return "//# " + l.getSpace() + l.getText();
        }
        return l.getSpace() + "//# " + l.getText();
    }

    String uncommentLine(PreprocessorLine l) {
        return l.getSpace() + l.getText();
    }

    public Strings getIncludeData(PreprocessorLine l) throws PreprocessorException {
        Strings include = new Strings();
        String name = this.utility.interpret(l.getArgs());
        File file = new File(name);
        if (!file.isAbsolute()) {
            name = this.file.getParent() + File.separatorChar + name;
        }
        try {
            if (this.encoding != null && this.encoding.length() != 0) {
                include.loadFromFile(new File(name), this.encoding);
            } else {
                include.loadFromFile(new File(name));
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new PreprocessorException("Unknown encoding \"" + this.encoding + "\" for " + file);
        }
        catch (IOException error) {
            throw new PreprocessorException("File \"" + name + "\" not found");
        }
        return include;
    }

    public boolean preprocess(Strings lines, String encoding) throws PreprocessorException, IOException {
        PreprocessorLine l;
        this.stack.clear();
        this.state = 0;
        Strings oldLines = new Strings();
        oldLines.assign(lines);
        int i = 0;
        while (i < lines.size()) {
            this.currentLine = i;
            String line = lines.get(i);
            try {
                l = this.analyzeLine(line);
                if (l.getType() == 12) {
                    Strings include = this.isBlind() ? null : this.getIncludeData(l);
                    ++i;
                    while (i < lines.size() && (l = this.analyzeLine(lines.get(i))).getType() != 13) {
                        lines.delete(i);
                    }
                    if (l.getType() != 13) {
                        throw new PreprocessorException("Missing #endinclude", this.file, this.currentLine);
                    }
                    if (include != null && (this.mode & 2) == 0) {
                        Preprocessor subfilter = new Preprocessor(this.utility, encoding);
                        subfilter.eval = this.eval;
                        subfilter.setFile(this.file);
                        subfilter.setMode(this.mode);
                        subfilter.preprocess(include, encoding);
                        for (int k = 0; k < include.size(); ++k) {
                            String s = include.get(k);
                            PreprocessorLine ln = this.analyzeLine(s);
                            if (ln.getType() != 0) continue;
                            lines.insert(i, s);
                            ++i;
                        }
                    }
                    ++i;
                    continue;
                }
                if (l.getType() == 0 || l.getType() == 1) {
                    if (this.isBlind()) {
                        lines.set(i, this.commentLine(l));
                        if ((this.mode & 0x10) != 0) {
                            System.out.println("Comment: " + l);
                        }
                    } else {
                        lines.set(i, this.uncommentLine(l));
                        if ((this.mode & 0x10) != 0) {
                            System.out.println("Uncomment: " + l);
                        }
                    }
                } else {
                    this.handleCommand(l);
                }
                ++i;
            }
            catch (PreprocessorException error) {
                throw new PreprocessorException(error.getMessage() + " in line " + (i + 1) + " : " + line, this.file, this.currentLine);
            }
        }
        if (this.state != 0) {
            throw new PreprocessorException("Missing #endif", this.file, this.currentLine);
        }
        if ((this.mode & 4) != 0) {
            for (int j = lines.size() - 1; j >= 0; --j) {
                l = this.analyzeLine(lines.get(j));
                if (l.getType() == 0) continue;
                lines.delete(j);
            }
        }
        boolean linesModified = !lines.equals(oldLines);
        return linesModified;
    }

    public void setSymbols(String symbols) throws PreprocessorException {
        this.eval = new BooleanEvaluator(symbols);
    }

    public void addSymbols(String defines) throws PreprocessorException {
        this.setSymbols(defines);
    }

    public void addSymbols(InputStream in) throws PreprocessorException, IOException {
        throw new UnsupportedOperationException("addSymbols(InputStream) is not supported by preprocessor v1");
    }

    public void addSymbols(File file) throws PreprocessorException, IOException {
        throw new UnsupportedOperationException("addSymbols(File) is not supported by preprocessor v1");
    }

    public void clearSymbols() throws PreprocessorException {
        this.eval = new BooleanEvaluator("");
    }

    public void outputDefinesToFile(File file, String encoding) throws PreprocessorException, IOException {
        throw new UnsupportedOperationException("outputSymbolsToFile is not supported by preprocessor v1");
    }

    public void printSymbols() throws PreprocessorException {
        this.utility.getProject().log("Symbols: " + this.eval.getDefines());
    }

    public void setDebugLevel(String level) throws PPException {
        throw new UnsupportedOperationException("setDebugLevel is not supported by preprocessor v1");
    }
}

