/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import de.pleumann.antenna.misc.Conditional;
import de.pleumann.antenna.misc.JadFile;
import de.pleumann.antenna.misc.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.ZipFileSet;

public class WtkPackage
extends Jar {
    private boolean verbose;
    private Vector preserve = new Vector();
    private Utility utility;
    private Conditional condition;
    private File jarFile;
    private File jadFile;
    private boolean autoversion;
    private boolean obfuscate;
    private boolean preverify;
    private boolean keepManifestOrder;
    private String config;
    private String profile;
    private Path bootclasspath;
    private Path classpath;
    private Path libclasspath;
    private File manifest;
    private Vector m_excludeFromManifest;
    private boolean cldc = true;
    private int flags;
    private String classDirs = "";

    public void init() throws BuildException {
        super.init();
        this.utility = Utility.getInstance(this.getProject(), (Task)this);
        this.config = "CLDC-" + this.utility.getCldcVersion();
        this.profile = "MIDP-" + this.utility.getMidpVersion();
        this.condition = new Conditional(this.getProject());
        this.classpath = new Path(this.getProject());
        this.setUpdate(false);
    }

    public Preserve createPreserve() {
        Preserve pre = new Preserve(this.getProject());
        this.preserve.addElement(pre);
        return pre;
    }

    public void setVerbose(boolean aVerbose) {
        this.verbose = aVerbose;
    }

    public void setJarfile(File jar) {
        super.setDestFile(jar);
        this.jarFile = jar;
    }

    public void setJadfile(File jad) {
        this.jadFile = jad;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setAutoversion(boolean version) {
        this.autoversion = version;
    }

    public void setCldc(boolean on) {
        this.cldc = on;
    }

    public void setNonative(boolean b) {
        this.flags = b ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setNofloat(boolean b) {
        this.flags = b ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public void setNofinalize(boolean b) {
        this.flags = b ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public void setSmartlink(boolean smartlink) {
        this.log("SmartLink is not supported in WtkPackage, use WtkSmartLink", 1);
    }

    public void setObfuscate(boolean obfuscate) {
        this.obfuscate = obfuscate;
    }

    public void setPreverify(boolean preverify) {
        this.preverify = preverify;
    }

    public void setBootclasspath(Path bootclasspath) {
        this.bootclasspath = bootclasspath;
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.getProject());
        }
        return this.bootclasspath.createPath();
    }

    public void setBootclasspathref(Reference r) {
        this.createBootclasspath().setRefid(r);
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathref(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setLibclasspath(Path libclasspath) {
        this.libclasspath = libclasspath;
    }

    public Path createLibclasspath() {
        if (this.libclasspath == null) {
            this.libclasspath = new Path(this.getProject());
        }
        return this.libclasspath.createPath();
    }

    public void setLibclasspathref(Reference r) {
        this.createLibclasspath().setRefid(r);
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
        super.setManifest(manifest);
    }

    public void addFileset(FileSet files) {
        super.addFileset(files);
        this.classDirs = this.classDirs + files.getDir(this.getProject()) + File.pathSeparator;
    }

    public Vector getPreserve() {
        Vector<Preserve> result = new Vector<Preserve>();
        for (int i = 0; i < this.preserve.size(); ++i) {
            Preserve p = (Preserve)this.preserve.elementAt(i);
            if (!p.isActive()) continue;
            result.add(p);
        }
        return result;
    }

    public void setIf(String s) {
        this.condition.setIf(s);
    }

    public void setUnless(String s) {
        this.condition.setUnless(s);
    }

    public void setKeepManifestOrder(boolean keep) {
        this.keepManifestOrder = keep;
    }

    public boolean isActive() {
        return this.condition.isActive();
    }

    private void addManifest(File tmpDir, File manFile) {
        try {
            FileInputStream manF = new FileInputStream(manFile);
            Manifest man = new Manifest(manF);
            File tmp = new File(tmpDir, this.jarFile.getName() + ".tmp");
            FileInputStream fis = new FileInputStream(this.jarFile);
            JarInputStream jis = new JarInputStream(fis);
            FileOutputStream fos = new FileOutputStream(tmp);
            JarOutputStream jos = new JarOutputStream((OutputStream)fos, man);
            byte[] buf = new byte[32768];
            JarEntry je = null;
            do {
                if ((je = (JarEntry)jis.getNextEntry()) == null) continue;
                if (!je.getName().equals("META-INF/MANIFEST.MF")) {
                    jos.putNextEntry(new ZipEntry(je.getName()));
                    int n = 0;
                    while ((n = jis.read(buf)) != -1) {
                        jos.write(buf, 0, n);
                    }
                }
                jos.closeEntry();
            } while (je != null);
            jos.flush();
            jos.close();
            this.utility.delete(this.jarFile);
            this.utility.copy(tmp, this.jarFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BuildException("Error re-ordering manifest " + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (!this.isActive()) {
            return;
        }
        File tmpDir = this.utility.getTempDir();
        try {
            String[] libs;
            String jar;
            if (this.bootclasspath == null) {
                String bcp = this.utility.getMidpApi();
                this.setBootclasspath(new Path(this.getProject(), bcp));
            }
            if (this.jadFile == null) {
                throw new BuildException("Required parameter jadfile missing");
            }
            JadFile jad = new JadFile();
            try {
                jad.load(this.jadFile.getAbsolutePath(), null);
            }
            catch (IOException ex) {
                throw new BuildException("Error loading JAD file", (Throwable)ex);
            }
            if (this.jarFile == null && (jar = jad.getValue("MIDlet-JAR-URL")) != null) {
                this.setJarfile(new File(this.jadFile.getParent() + "/" + new File(jar).getName()));
            }
            JadFile man = new JadFile();
            if (this.manifest == null) {
                Vector<String> excludes = new Vector<String>();
                for (int i = 0; i < this.m_excludeFromManifest.size(); ++i) {
                    Exclude_From_Manifest ex = (Exclude_From_Manifest)this.m_excludeFromManifest.get(i);
                    if (ex.name != null) {
                        excludes.add(ex.name);
                        continue;
                    }
                    if (ex.list != null) {
                        StringTokenizer tok = new StringTokenizer(ex.list, ",");
                        while (tok.hasMoreElements()) {
                            excludes.add(tok.nextToken().trim());
                        }
                        continue;
                    }
                    throw new BuildException("At least one of list or name must not be null in Exclude_From_Manifest");
                }
                Object[] eStr = new String[excludes.size()];
                excludes.copyInto(eStr);
                man.setExcludeFromManifest((String[])eStr);
                man.assign(jad, true);
                man.setValue("MIDlet-Jar-URL", null);
                man.setValue("MIDlet-Jar-Size", null);
                man.setValue("MicroEdition-Configuration", this.config);
                man.setValue("MicroEdition-Profile", this.profile);
            } else {
                try {
                    man.load(this.manifest.getAbsolutePath(), null);
                }
                catch (IOException ex) {
                    throw new BuildException("Error opening MANIFEST.MF file ", (Throwable)ex);
                }
            }
            String newVersion = null;
            if (this.autoversion) {
                newVersion = this.utility.getNewVersion(jad.getValue("MIDlet-Version"));
                jad.setValue("MIDlet-Version", newVersion);
                man.setValue("MIDlet-Version", newVersion);
            }
            File manFile = this.manifest == null ? new File(tmpDir + "/MANIFEST.MF") : this.manifest;
            try {
                man.save("" + manFile, null);
            }
            catch (IOException ex) {
                throw new BuildException("Error writing MANIFEST.MF file", (Throwable)ex);
            }
            super.setManifest(manFile);
            if (this.libclasspath != null && (libs = this.libclasspath.list()) != null) {
                for (int i = 0; i < libs.length; ++i) {
                    File lib = new File(libs[i]);
                    if (!lib.isDirectory()) {
                        ZipFileSet zip = new ZipFileSet();
                        zip.setProject(this.getProject());
                        zip.setSrc(lib);
                        zip.createExclude().setName("META-INF/**");
                        this.addZipfileset(zip);
                        continue;
                    }
                    FileSet dir = new FileSet();
                    dir.setDir(lib);
                    dir.createExclude().setName("META-INF/**");
                    this.addFileset(dir);
                }
            }
            String cp = "" + this.bootclasspath;
            if (this.classpath.size() != 0) {
                cp = cp + File.pathSeparator + this.classpath;
            }
            super.execute();
            if (this.obfuscate) {
                File obfFile = new File(tmpDir + "/obfuscated.jar");
                Vector preserve = new Vector();
                this.utility.getPreserveList(jad, preserve);
                preserve.addAll(this.getPreserve());
                this.utility.obfuscate(this.jarFile, obfFile, cp, this.verbose, preserve, null, null, jad);
                Jar jar2 = new Jar();
                jar2.setProject(this.getProject());
                jar2.setTaskName(this.getTaskName());
                jar2.setDestFile(obfFile);
                jar2.setManifest(manFile);
                jar2.setUpdate(true);
                jar2.execute();
                this.utility.copy(obfFile, this.jarFile);
            }
            if (this.preverify) {
                this.utility.preverify(this.jarFile, tmpDir, cp, this.cldc, this.flags);
                this.utility.copy(new File(tmpDir + File.separator + this.jarFile.getName()), this.jarFile);
            }
            if (this.keepManifestOrder) {
                this.addManifest(tmpDir, manFile);
            }
            if (jad.getValue("MIDlet-Jar-URL") == null) {
                jad.setValue("MIDlet-Jar-URL", "" + this.jarFile.getName());
            }
            jad.setValue("MIDlet-Jar-Size", "" + this.jarFile.length());
            this.log("Updating JAD file " + this.jadFile);
            try {
                jad.save("" + this.jadFile, null);
            }
            catch (IOException ex) {
                throw new BuildException("Error processing JAD file", (Throwable)ex);
            }
        }
        finally {
            this.utility.delete(tmpDir);
        }
    }

    public Exclude_From_Manifest createExclude_From_Manifest() {
        if (this.m_excludeFromManifest == null) {
            this.m_excludeFromManifest = new Vector();
        }
        Exclude_From_Manifest a = new Exclude_From_Manifest();
        this.m_excludeFromManifest.addElement(a);
        return a;
    }

    public static class Exclude_From_Manifest {
        private String name;
        private String list;

        public void setName(String name) {
            this.name = name;
        }

        public void setList(String list) {
            this.list = list;
        }
    }

    public class Preserve
    extends Conditional {
        private String value;

        public Preserve(Project project) {
            super(project);
            this.value = "";
        }

        public void setClass(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

