/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.http;

import de.pleumann.antenna.misc.JadFile;
import de.pleumann.antenna.misc.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OTAServer
extends HttpServlet {
    private File files;
    private String login;
    private String password;
    private Strings htmlpage;
    private Strings wmlpage;
    private Strings counters;

    public void init() throws ServletException {
        super.init();
        String s = this.getInitParameter("files");
        this.files = s == null ? new File(this.getServletContext().getRealPath("/WEB-INF/files")) : new File(s);
        this.files.mkdirs();
        this.login = this.getInitParameter("login");
        this.password = this.getInitParameter("password");
        this.htmlpage = new Strings();
        try {
            this.htmlpage.loadFromFile(this.getServletContext().getRealPath("/WEB-INF/") + "/index.html");
        }
        catch (IOException ex) {
            try {
                this.htmlpage.loadFromStream(((Object)((Object)this)).getClass().getResourceAsStream("/index.html"));
            }
            catch (IOException ignored) {
                this.htmlpage.clear();
            }
        }
        this.wmlpage = new Strings();
        try {
            this.wmlpage.loadFromFile(this.getServletContext().getRealPath("/WEB-INF/") + "/index.wml");
        }
        catch (IOException ex) {
            try {
                this.wmlpage.loadFromStream(((Object)((Object)this)).getClass().getResourceAsStream("/index.wml"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.counters = new Strings();
        try {
            this.counters.loadFromFile(this.getServletContext().getRealPath("/WEB-INF/") + "/counter.txt");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter writer;
        System.out.println("" + new Date() + " GET " + request.getPathInfo());
        this.showInfo(request);
        String name = request.getPathInfo();
        if (name == null || "/".equals(name)) {
            boolean html;
            String accept = request.getHeader("accept");
            if (accept == null) {
                accept = "*/*";
            }
            boolean wml = accept.indexOf("text/vnd.wap.wml") != -1;
            boolean bl = html = accept.indexOf("text/html") != -1 || accept.indexOf("*/*") != -1;
            if (wml && !html) {
                name = "/index.wml";
            } else {
                response.setStatus(303);
                response.setHeader("Location", this.getBaseURL(request) + "/index.html");
                return;
            }
        }
        if ("/index.html".equals(name)) {
            response.setContentType("text/html");
            writer = response.getWriter();
            this.listFiles(request, this.htmlpage, writer);
        } else if ("/index.wml".equals(name) || "/wap".equals(name)) {
            response.setContentType("text/vnd.wap.wml");
            writer = response.getWriter();
            this.listFiles(request, this.wmlpage, writer);
        } else {
            File file = new File(this.files + name);
            if (!file.exists()) {
                response.setStatus(404);
                return;
            }
            if (file.getName().endsWith(".jad")) {
                response.setContentType("text/vnd.sun.j2me.app-descriptor");
                JadFile jad = new JadFile();
                jad.load(file.getAbsolutePath(), null);
                String s = new File(jad.getValue("MIDlet-Jar-URL")).getName();
                jad.setValue("MIDlet-Jar-URL", this.getBaseURL(request) + "/" + s);
                jad.save((OutputStream)response.getOutputStream());
            } else if (file.getName().endsWith(".jar")) {
                response.setContentType("application/java-archive");
                response.setContentLength(new Long(file.length()).intValue());
                FileInputStream input = new FileInputStream(file);
                ServletOutputStream output = response.getOutputStream();
                OTAServer.copyStreams(input, (OutputStream)output);
                ((InputStream)input).close();
                output.flush();
                this.increaseCounter(file.getName());
            } else {
                response.setStatus(404);
                return;
            }
        }
        response.setStatus(200);
        System.out.println("Ok.");
    }

    private void showInfo(HttpServletRequest request) {
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String s = (String)headers.nextElement();
            System.out.println(s + "=" + request.getHeader(s));
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        System.out.println("" + new Date() + " PUT " + request.getPathInfo());
        if (!(this.login == null || this.password == null || this.login.equals(request.getParameter("login")) && this.password.equals(request.getParameter("password")))) {
            response.setStatus(401);
            return;
        }
        if ("true".equals(request.getParameter("delete"))) {
            String name = request.getPathInfo();
            new File(this.files + name).delete();
        } else {
            String name = request.getPathInfo();
            if (name == null || "/".equals(name)) {
                response.setStatus(500);
            }
            File file = new File(this.files + name);
            FileOutputStream output = new FileOutputStream(file);
            ServletInputStream input = request.getInputStream();
            OTAServer.copyStreams((InputStream)input, output);
            output.flush();
            ((OutputStream)output).close();
        }
        response.setStatus(200);
    }

    private synchronized void increaseCounter(String name) {
        try {
            String num = this.counters.getValue(name);
            if (num == null) {
                num = "0";
            }
            int i = Integer.parseInt(num) + 1;
            this.counters.setValue(name, "" + i);
            this.counters.saveToFile(this.getServletContext().getRealPath("/WEB-INF/") + "/counter.txt");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getBaseURL(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
    }

    private void listFiles(HttpServletRequest request, Strings template, PrintWriter writer) throws IOException {
        int i;
        int begin = template.indexOf("<!-- BEGIN -->");
        int end = template.indexOf("<!-- END -->");
        for (int i2 = 0; i2 < begin - 1; ++i2) {
            writer.println(template.get(i2));
        }
        Object[] list = this.files.listFiles();
        if (list != null) {
            Arrays.sort(list);
            for (i = 0; i < list.length; ++i) {
                if (!((File)list[i]).getName().endsWith(".jad")) continue;
                JadFile jad = new JadFile();
                jad.load(((File)list[i]).getAbsolutePath(), null);
                for (int j = begin + 1; j < end; ++j) {
                    StringBuffer s = new StringBuffer(template.get(j));
                    int p = s.indexOf("${");
                    while (p != -1) {
                        String key;
                        String value;
                        int q = s.indexOf("}", p + 2);
                        if (q == -1) {
                            q = p + 2;
                        }
                        if ((value = jad.getValue(key = s.substring(p + 2, q))) == null) {
                            value = "---";
                        }
                        if ("File".equals(key)) {
                            value = this.getBaseURL(request) + "/" + ((File)list[i]).getName();
                        } else if ("Date".equals(key)) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTimeInMillis(((File)list[i]).lastModified());
                            String monthNames = "JanFebMarAprMayJunJulAugSepOctNovDec";
                            int month = calendar.get(2);
                            String year = "" + calendar.get(1);
                            year = year.substring(2);
                            value = calendar.get(5) + "-" + monthNames.substring(3 * month, 3 * month + 3) + "-" + year;
                        } else if ("Counter".equals(key)) {
                            value = this.counters.getValue(new File(jad.getValue("MIDlet-Jar-URL")).getName());
                            if (value == null) {
                                value = "0";
                            }
                        } else if ("MIDlet-Jar-URL".equals(key)) {
                            value = this.getBaseURL(request) + "/" + new File(value).getName();
                        }
                        value = this.encode(value);
                        s.replace(p, q + 1, value);
                        p = s.indexOf("${");
                    }
                    writer.println(s);
                }
            }
        }
        for (i = end + 1; i < template.size(); ++i) {
            writer.println(template.get(i));
        }
    }

    private String encode(String s) {
        StringBuffer result = new StringBuffer();
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static void copyStreams(InputStream source, OutputStream target) throws IOException {
        byte[] buffer = new byte[128];
        int i = source.read(buffer);
        while (i != -1) {
            target.write(buffer, 0, i);
            i = source.read(buffer);
        }
    }
}

