/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.tigris.subversion.svnant.ISvnAntProjectComponent;
import org.tigris.subversion.svnant.commands.Add;
import org.tigris.subversion.svnant.commands.Cat;
import org.tigris.subversion.svnant.commands.Checkout;
import org.tigris.subversion.svnant.commands.Commit;
import org.tigris.subversion.svnant.commands.Copy;
import org.tigris.subversion.svnant.commands.CreateRepository;
import org.tigris.subversion.svnant.commands.Delete;
import org.tigris.subversion.svnant.commands.Diff;
import org.tigris.subversion.svnant.commands.Export;
import org.tigris.subversion.svnant.commands.Feedback;
import org.tigris.subversion.svnant.commands.Ignore;
import org.tigris.subversion.svnant.commands.Import;
import org.tigris.subversion.svnant.commands.Info;
import org.tigris.subversion.svnant.commands.Keywordsadd;
import org.tigris.subversion.svnant.commands.Keywordsremove;
import org.tigris.subversion.svnant.commands.Keywordsset;
import org.tigris.subversion.svnant.commands.Log;
import org.tigris.subversion.svnant.commands.Mkdir;
import org.tigris.subversion.svnant.commands.Move;
import org.tigris.subversion.svnant.commands.Propdel;
import org.tigris.subversion.svnant.commands.Propget;
import org.tigris.subversion.svnant.commands.Propset;
import org.tigris.subversion.svnant.commands.Revert;
import org.tigris.subversion.svnant.commands.Status;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnant.commands.Switch;
import org.tigris.subversion.svnant.commands.Update;
import org.tigris.subversion.svnant.commands.WcVersion;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javasvn.JavaSvnClientAdapterFactory;

public class SvnTask
extends Task
implements ISvnAntProjectComponent {
    private static boolean javahlAvailableInitialized = false;
    private static boolean javahlAvailable;
    private static boolean javaSVNAvailableInitialized;
    private static boolean javaSVNAvailable;
    private static boolean commandLineAvailableInitialized;
    private static boolean commandLineAvailable;
    private String username = null;
    private String password = null;
    private boolean javahl = true;
    private boolean javasvn = true;
    private String dateFormatter = null;
    private TimeZone dateTimeZone = null;
    private boolean failonerror = true;
    private List commands = new ArrayList();
    private List notifyListeners = new ArrayList();

    public boolean getJavahl() {
        return this.javahl;
    }

    public boolean getJavaSvn() {
        return this.javasvn;
    }

    public ProjectComponent getProjectComponent() {
        return this;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = "\"\"".equals(string) ? "" : string;
    }

    public void setJavahl(boolean bl) {
        this.javahl = bl;
    }

    public void setJavasvn(boolean bl) {
        this.javasvn = bl;
    }

    public String getDateFormatter() {
        return this.dateFormatter != null ? this.dateFormatter : "MM/dd/yyyy hh:mm a";
    }

    public void setDateFormatter(String string) {
        this.dateFormatter = string;
    }

    public TimeZone getDateTimeZone() {
        return this.dateTimeZone;
    }

    public void setDateTimezone(String string) {
        this.dateTimeZone = TimeZone.getTimeZone(string);
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    public void addCheckout(Checkout checkout) {
        this.addCommand(checkout);
    }

    public void addAdd(Add add) {
        this.addCommand(add);
    }

    public void addCommit(Commit commit) {
        this.addCommand(commit);
    }

    public void addCopy(Copy copy) {
        this.addCommand(copy);
    }

    public void addDelete(Delete delete) {
        this.addCommand(delete);
    }

    public void addExport(Export export) {
        this.addCommand(export);
    }

    public void addInfo(Info info) {
        this.addCommand(info);
    }

    public void addImport(Import import_) {
        this.addCommand(import_);
    }

    public void addLog(Log log) {
        this.addCommand(log);
    }

    public void addMkdir(Mkdir mkdir) {
        this.addCommand(mkdir);
    }

    public void addMove(Move move) {
        this.addCommand(move);
    }

    public void addUpdate(Update update) {
        this.addCommand(update);
    }

    public void addPropset(Propset propset) {
        this.addCommand(propset);
    }

    public void addDiff(Diff diff) {
        this.addCommand(diff);
    }

    public void addKeywordsSet(Keywordsset keywordsset) {
        this.addCommand(keywordsset);
    }

    public void addKeywordsAdd(Keywordsadd keywordsadd) {
        this.addCommand(keywordsadd);
    }

    public void addKeywordsRemove(Keywordsremove keywordsremove) {
        this.addCommand(keywordsremove);
    }

    public void addRevert(Revert revert) {
        this.addCommand(revert);
    }

    public void addCat(Cat cat) {
        this.addCommand(cat);
    }

    public void addPropdel(Propdel propdel) {
        this.addCommand(propdel);
    }

    public void addIgnore(Ignore ignore) {
        this.addCommand(ignore);
    }

    public void addCreateRepository(CreateRepository createRepository) {
        this.addCommand(createRepository);
    }

    public void addWcVersion(WcVersion wcVersion) {
        this.addCommand(wcVersion);
    }

    public void addStatus(Status status) {
        this.addCommand(status);
    }

    public void addSwitch(Switch switch_) {
        this.addCommand(switch_);
    }

    public void addPropget(Propget propget) {
        this.addCommand(propget);
    }

    private void addCommand(SvnCommand svnCommand) {
        svnCommand.setTask(this);
        this.commands.add(svnCommand);
    }

    public void addNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        this.notifyListeners.add(iSVNNotifyListener);
    }

    public static boolean isJavahlAvailable() {
        if (!javahlAvailableInitialized) {
            try {
                JhlClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            javahlAvailable = false;
            try {
                javahlAvailable = SVNClientAdapterFactory.isSVNClientAvailable((String)"javahl");
            }
            catch (Exception exception) {
                // empty catch block
            }
            javahlAvailableInitialized = true;
        }
        return javahlAvailable;
    }

    public static boolean isJavaSVNAvailable() {
        if (!javaSVNAvailableInitialized) {
            try {
                JavaSvnClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            javaSVNAvailable = false;
            try {
                javaSVNAvailable = SVNClientAdapterFactory.isSVNClientAvailable((String)"javasvn");
            }
            catch (Exception exception) {
                // empty catch block
            }
            javaSVNAvailableInitialized = true;
        }
        return javaSVNAvailable;
    }

    public static boolean isCommandLineAvailable() {
        if (!commandLineAvailableInitialized) {
            try {
                CmdLineClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            commandLineAvailable = SVNClientAdapterFactory.isSVNClientAvailable((String)"commandline");
            commandLineAvailableInitialized = true;
        }
        return commandLineAvailable;
    }

    public void maybeConfigure() throws BuildException {
        super.maybeConfigure();
    }

    public void execute() throws BuildException {
        int n;
        ISVNClientAdapter iSVNClientAdapter = SvnTask.getClientAdapter(this);
        if (this.username != null) {
            iSVNClientAdapter.setUsername(this.username);
        }
        if (this.password != null) {
            iSVNClientAdapter.setPassword(this.password);
        }
        for (n = 0; n < this.notifyListeners.size(); ++n) {
            iSVNClientAdapter.addNotifyListener((ISVNNotifyListener)this.notifyListeners.get(n));
        }
        for (n = 0; n < this.commands.size(); ++n) {
            SvnCommand svnCommand = (SvnCommand)((Object)this.commands.get(n));
            Feedback feedback = new Feedback(svnCommand);
            iSVNClientAdapter.addNotifyListener((ISVNNotifyListener)feedback);
            svnCommand.executeCommand(iSVNClientAdapter);
            iSVNClientAdapter.removeNotifyListener((ISVNNotifyListener)feedback);
        }
    }

    public static ISVNClientAdapter getClientAdapter(ISvnAntProjectComponent iSvnAntProjectComponent) throws BuildException {
        ISVNClientAdapter iSVNClientAdapter;
        if (iSvnAntProjectComponent.getJavahl() && SvnTask.isJavahlAvailable()) {
            iSVNClientAdapter = SVNClientAdapterFactory.createSVNClient((String)"javahl");
            iSvnAntProjectComponent.getProjectComponent().log("Using javahl", 3);
        } else if (iSvnAntProjectComponent.getJavaSvn() && SvnTask.isJavaSVNAvailable()) {
            iSVNClientAdapter = SVNClientAdapterFactory.createSVNClient((String)"javasvn");
            iSvnAntProjectComponent.getProjectComponent().log("Using javasvn", 3);
        } else if (SvnTask.isCommandLineAvailable()) {
            iSVNClientAdapter = SVNClientAdapterFactory.createSVNClient((String)"commandline");
            iSvnAntProjectComponent.getProjectComponent().log("Using command line interface", 3);
        } else {
            throw new BuildException("Cannot use javahl, JavaSVN nor command line svn client");
        }
        return iSVNClientAdapter;
    }

    static {
        javaSVNAvailableInitialized = false;
        commandLineAvailableInitialized = false;
    }
}

