/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class AccessFixer
extends SimplifiedVisitor
implements ConstantVisitor,
ClassVisitor,
MemberVisitor {
    private Clazz referencingClass;

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.referencingClass = clazz;
        stringConstant.referencedClassAccept(this);
        stringConstant.referencedMemberAccept(this);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.referencingClass = clazz;
        refConstant.referencedMemberAccept(this);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.referencingClass = clazz;
        classConstant.referencedClassAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        int n;
        int n2 = programClass.getAccessFlags();
        int n3 = AccessUtil.accessLevel(n2);
        Clazz clazz = this.referencingClass;
        int n4 = programClass.equals(this.referencingClass) ? 0 : (this.inSamePackage(programClass, clazz) ? 1 : (n = clazz.extends_(programClass) ? 2 : 3));
        if (n3 < n) {
            programClass.u2accessFlags = AccessUtil.replaceAccessFlags(n2, AccessUtil.accessFlags(n));
        }
    }

    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        int n;
        int n2 = programMember.getAccessFlags();
        int n3 = AccessUtil.accessLevel(n2);
        int n4 = programClass.equals(this.referencingClass) ? 0 : (n = this.inSamePackage(programClass, this.referencingClass) ? 1 : 3);
        if (n3 < n) {
            programMember.u2accessFlags = AccessUtil.replaceAccessFlags(n2, AccessUtil.accessFlags(n));
        }
    }

    private boolean inSamePackage(ProgramClass programClass, Clazz clazz) {
        return ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(clazz.getName()));
    }
}

