/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.property;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class Variable
extends Task {
    private String value = "";
    private String name = null;
    private File file = null;
    private boolean remove = false;

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setUnset(boolean b) {
        this.remove = b;
    }

    public void execute() throws BuildException {
        if (this.remove) {
            if ((this.name == null || this.name.equals("")) && this.file == null) {
                throw new BuildException("The 'name' or 'file' attribute are required with 'unset'.");
            }
            if (this.file != null) {
                this.unloadFile(this.file);
            }
            if (this.name == null || this.name.equals("")) {
                this.removeProperty(this.name);
            }
            return;
        }
        if (this.file == null) {
            if (this.name == null || this.name.equals("")) {
                throw new BuildException("The 'name' attribute is required.");
            }
            if (this.value == null) {
                this.value = "";
            }
            this.value = this.getProject().replaceProperties(this.value);
            this.forceProperty(this.name, this.value);
        } else {
            if (!this.file.exists()) {
                throw new BuildException(this.file.getAbsolutePath() + " does not exists.");
            }
            this.loadFile(this.file);
        }
    }

    private void removeProperty(String name) {
        block14: {
            Hashtable properties = null;
            try {
                properties = (Hashtable)this.getValue(this.getProject(), "properties");
                if (properties != null) {
                    properties.remove(name);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                properties = (Hashtable)this.getValue(this.getProject(), "userProperties");
                if (properties != null) {
                    properties.remove(name);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Object property_helper = this.getProject().getReference("ant.PropertyHelper");
                if (property_helper == null) break block14;
                try {
                    properties = (Hashtable)this.getValue(property_helper, "properties");
                    if (properties != null) {
                        properties.remove(name);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    properties = (Hashtable)this.getValue(property_helper, "userProperties");
                    if (properties != null) {
                        properties.remove(name);
                    }
                }
                catch (Exception e) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void forceProperty(String name, String value) {
        try {
            Hashtable properties = (Hashtable)this.getValue(this.getProject(), "properties");
            if (properties == null) {
                this.getProject().setUserProperty(name, value);
            } else {
                properties.put(name, value);
            }
        }
        catch (Exception e) {
            this.getProject().setUserProperty(name, value);
        }
    }

    private Field getField(Class thisClass, String fieldName) throws NoSuchFieldException {
        if (thisClass == null) {
            throw new NoSuchFieldException("Invalid field : " + fieldName);
        }
        try {
            return thisClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return this.getField(thisClass.getSuperclass(), fieldName);
        }
    }

    private Object getValue(Object instance, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = this.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile(File file) throws BuildException {
        block8: {
            Properties props = new Properties();
            try {
                if (file.exists()) {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        props.load(fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    this.addProperties(props);
                    break block8;
                }
                this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex, this.location);
            }
        }
    }

    protected void addProperties(Properties props) {
        this.resolveAllProperties(props);
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            this.forceProperty(name, value);
        }
    }

    private void resolveAllProperties(Properties props) throws BuildException {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            boolean resolved = false;
            while (!resolved) {
                Vector fragments = new Vector();
                Vector propertyRefs = new Vector();
                ProjectHelper.parsePropertyString((String)value, fragments, propertyRefs);
                resolved = true;
                if (propertyRefs.size() == 0) continue;
                StringBuffer sb = new StringBuffer();
                Enumeration i = fragments.elements();
                Enumeration j = propertyRefs.elements();
                while (i.hasMoreElements()) {
                    String fragment = (String)i.nextElement();
                    if (fragment == null) {
                        String propertyName = (String)j.nextElement();
                        if (propertyName.equals(name)) {
                            throw new BuildException("Property " + name + " was circularly " + "defined.");
                        }
                        fragment = this.getProject().getProperty(propertyName);
                        if (fragment == null) {
                            if (props.containsKey(propertyName)) {
                                fragment = props.getProperty(propertyName);
                                resolved = false;
                            } else {
                                fragment = "${" + propertyName + "}";
                            }
                        }
                    }
                    sb.append(fragment);
                }
                value = sb.toString();
                props.put(name, value);
            }
        }
    }

    private void unloadFile(File file) throws BuildException {
        Properties props = new Properties();
        if (!file.exists()) {
            this.log("Unable to find property file: " + file.getAbsolutePath(), 3);
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(file);
            props.load(fis);
            if (fis != null) {
                fis.close();
            }
            if (fis != null) {
                fis.close();
            }
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.log("Unloading " + key + " = " + this.getProject().getProperty(key), 3);
                this.removeProperty(key);
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }
}

