/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import antenna.preprocessor.IPreprocessor;
import antenna.preprocessor.PreprocessorException;
import antenna.preprocessor.v1.Preprocessor;
import antenna.preprocessor.v2.PreprocessorBridge;
import de.pleumann.antenna.device.DeviceProps;
import de.pleumann.antenna.device.Devices;
import de.pleumann.antenna.misc.Conditional;
import de.pleumann.antenna.misc.Strings;
import de.pleumann.antenna.misc.Utility;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class WtkPreprocess
extends MatchingTask {
    private Conditional condition;
    private File sourceDir;
    private File targetDir;
    private String newext;
    private String encoding;
    private int mode = 128;
    private Utility utility;
    private String m_symbols;
    private String m_device;
    private String m_saveSymbols;
    private String m_backendVersion = "2";
    private boolean m_printSymbols = false;
    private Vector m_symbolsFile = new Vector();
    private String m_debugLevel;

    public void init() {
        super.init();
        this.utility = Utility.getInstance(this.getProject(), (Task)this);
        this.condition = new Conditional(this.getProject());
        this.sourceDir = this.getProject().resolveFile(".");
        this.createInclude().setName("**/*.java");
    }

    public void setSrcdir(File value) {
        this.sourceDir = value;
    }

    public void setDestdir(File value) {
        this.targetDir = value;
    }

    public void setSymbols(String symbols) {
        this.m_symbols = symbols;
    }

    public void setVerbose(boolean verbose) {
        this.mode = verbose ? (this.mode |= 0x10) : (this.mode &= 0xFFFFFFEF);
    }

    public void setBackup(boolean backup) {
        this.mode = backup ? (this.mode |= 1) : (this.mode &= 0xFFFFFFFE);
    }

    public void setIndent(boolean indent) {
        this.mode = indent ? (this.mode |= 0x80) : (this.mode &= 0xFFFFFF7F);
    }

    public void setTest(boolean test) {
        this.mode = test ? (this.mode |= 8) : (this.mode &= 0xFFFFFFF7);
    }

    public void setFilter(boolean filter) {
        this.mode = filter ? (this.mode |= 4) : (this.mode &= 0xFFFFFFFB);
    }

    public void setNewext(String newext) {
        this.newext = newext;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIf(String s) {
        this.condition.setIf(s);
    }

    public void setUnless(String s) {
        this.condition.setUnless(s);
    }

    public boolean isActive() {
        return this.condition.isActive();
    }

    public void execute() throws BuildException {
        if (!this.isActive()) {
            return;
        }
        if (this.targetDir == null) {
            throw new BuildException("Need a target directory");
        }
        StringTokenizer tok = new StringTokenizer(this.sourceDir.toString(), "" + File.pathSeparatorChar);
        while (tok.hasMoreElements()) {
            String dir = tok.nextToken();
            try {
                IPreprocessor pp;
                if ("1".equals(this.m_backendVersion)) {
                    pp = new Preprocessor(this.utility, this.encoding);
                    pp.addSymbols(this.m_symbols);
                    if (this.m_printSymbols) {
                        pp.printSymbols();
                    }
                } else if ("2".equals(this.m_backendVersion)) {
                    pp = new PreprocessorBridge(this.utility);
                    try {
                        pp.setDebugLevel(this.m_debugLevel);
                    }
                    catch (Exception e) {
                        this.log(e.getMessage(), 1);
                    }
                    String deviceDefines = this.getDeviceDefines();
                    String symbols = this.addSymbols(this.m_symbols, deviceDefines);
                    pp.addSymbols(symbols);
                    for (int i = 0; i < this.m_symbolsFile.size(); ++i) {
                        Symbols_File f = (Symbols_File)this.m_symbolsFile.get(i);
                        if (f.name != null) {
                            File file = new File(f.name);
                            if (!file.exists()) {
                                this.log("Symbols file not found : " + file.getAbsolutePath(), 2);
                                continue;
                            }
                            try {
                                pp.addSymbols(file);
                            }
                            catch (PreprocessorException e) {
                                this.log("Error preprocessing symbols" + file.getAbsolutePath(), 0);
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                this.log("IOException adding " + file.getAbsolutePath(), 0);
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (f.list == null) continue;
                        StringTokenizer t = new StringTokenizer(f.list, " ,");
                        while (t.hasMoreElements()) {
                            File ff = new File(t.nextToken());
                            if (!ff.exists()) {
                                this.log("Symbols file not found : " + ff.getAbsolutePath(), 1);
                                continue;
                            }
                            try {
                                pp.addSymbols(ff);
                            }
                            catch (Exception e) {
                                this.log("Error adding symbols from " + ff.getAbsolutePath(), 1);
                            }
                        }
                    }
                    if (this.m_printSymbols) {
                        pp.printSymbols();
                    }
                    if (this.m_saveSymbols != null) {
                        try {
                            pp.outputDefinesToFile(new File(this.m_saveSymbols), this.encoding);
                        }
                        catch (IOException e) {
                            this.log("Error saving defines to file " + this.m_saveSymbols, 1);
                        }
                    }
                } else {
                    throw new BuildException("Unsupported backend version " + this.m_backendVersion);
                }
                File file = new File(dir);
                this.preprocess(pp, file, this.mode, this.newext, this.encoding, this.utility);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new BuildException("Preprocessing failed: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void preprocess(IPreprocessor pp, File sourceDir, int mode, String newext, String encoding, Utility utility) throws PreprocessorException, IOException {
        pp.setMode(mode);
        String[] files = this.getDirectoryScanner(sourceDir).getIncludedFiles();
        this.log("Preprocessing " + files.length + " file(s) at " + sourceDir);
        String filename = "";
        try {
            for (int i = 0; i < files.length; ++i) {
                filename = files[i];
                String sourceFile = "" + sourceDir + File.separatorChar + filename;
                Strings lines = this.loadFile(encoding, new File(sourceFile));
                pp.setFile(new File(sourceFile));
                boolean modified = pp.preprocess(lines, encoding);
                if (modified || !sourceDir.equals(this.targetDir) || newext != null) {
                    try {
                        if ((mode & 0x10) != 0) {
                            System.out.println(filename + " ... modified");
                        }
                        if ((mode & 8) != 0) continue;
                        if (newext != null) {
                            int dot = filename.indexOf(46);
                            filename = dot != -1 ? filename.substring(0, dot) + newext : filename + newext;
                        }
                        String targetFile = "" + this.targetDir + File.separatorChar + filename;
                        File file = new File(targetFile + "~");
                        file.delete();
                        if (!new File(targetFile).renameTo(file) && this.targetDir == null) {
                            throw new IOException();
                        }
                        new File(targetFile).getParentFile().mkdirs();
                        if (encoding != null && encoding.length() > 0) {
                            lines.saveToFile(targetFile, encoding);
                        } else {
                            lines.saveToFile(targetFile);
                        }
                        if ((mode & 1) != 0) continue;
                        file.delete();
                        continue;
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new PreprocessorException("Unknown encoding \"" + encoding, new File(files[i]));
                    }
                    catch (IOException e) {
                        throw new PreprocessorException("File write error", new File(files[i]));
                    }
                }
                if ((mode & 0x10) == 0) continue;
                System.out.println(filename + " ... not modified");
            }
        }
        catch (IOException e) {
            if ((mode & 0x10) == 0) {
                System.out.println(filename + " ... not modified, " + e.getMessage());
            }
            throw e;
        }
        catch (PreprocessorException error) {
            if ((mode & 0x10) == 0) {
                System.out.println(filename + " ... not modified, " + error.getMessage());
            }
            throw error;
        }
    }

    private Strings loadFile(String encoding, File sourceFile) throws PreprocessorException {
        Strings lines = new Strings();
        try {
            if (encoding != null && encoding.length() > 0) {
                lines.loadFromFile(sourceFile, encoding);
            } else {
                lines.loadFromFile(sourceFile);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new PreprocessorException("Unknown encoding \"" + encoding + "\"", sourceFile, e);
        }
        catch (IOException e) {
            throw new PreprocessorException("File read error", sourceFile, e);
        }
        return lines;
    }

    public void setDevice(String device) {
        this.m_device = device;
    }

    private String getDeviceDefines() {
        DeviceProps deviceProps = Devices.getDevice(this.m_device);
        String deviceDefines = "";
        if (deviceProps == null) {
            this.getProject().log("Warning: unknown device \"" + this.m_device + "\"");
        } else {
            deviceDefines = deviceProps.getDefinesString();
        }
        return deviceDefines;
    }

    private String addSymbols(String current, String deviceDefines) {
        String s = "";
        s = this.append(this.m_symbols, s);
        s = this.append(s, deviceDefines);
        return s;
    }

    private String append(String cur, String s) {
        if (cur == null || cur.length() == 0) {
            return s;
        }
        String ss = s != null && s.length() > 0 ? cur + "," + s : cur;
        return ss;
    }

    public void setVersion(String backendVersion) {
        this.m_backendVersion = backendVersion;
    }

    public void setPrintSymbols(boolean printSymbols) {
        this.m_printSymbols = printSymbols;
    }

    public Symbols_File createSymbols_File() {
        Symbols_File a = new Symbols_File();
        this.m_symbolsFile.addElement(a);
        return a;
    }

    public void setSaveSymbols(String file) {
        this.m_saveSymbols = file;
    }

    public void setDebugLevel(String debug) {
        this.m_debugLevel = debug;
    }

    public void setDeviceDBPath(String path) throws BuildException {
        try {
            Devices.setDatabaseDir(path);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public static class Symbols_File {
        private String name;
        private String list;

        public void setName(String name) {
            this.name = name;
        }

        public void setList(String list) {
            this.list = list;
        }
    }
}

