/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.device;

import de.pleumann.antenna.device.BaseProps;
import de.pleumann.antenna.device.Util;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Group
extends BaseProps {
    protected String m_name;
    private String m_parent;

    public Group(Element dev) {
        super(dev);
        NodeList props = dev.getChildNodes();
        for (int i = 0; i < props.getLength(); ++i) {
            Node item = props.item(i);
            if (!(item instanceof Element)) continue;
            Element e = (Element)item;
            String tagName = e.getTagName();
            if ("name".equals(tagName)) {
                this.m_name = Util.getText(e);
                continue;
            }
            if (!"parent".equals(tagName)) continue;
            this.m_parent = Util.getText(e);
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getParent() {
        return this.m_parent;
    }

    public Properties constructCapabilities(Hashtable groups, Hashtable capTable) {
        Group parentGroup;
        Properties base = new Properties();
        if (this.m_parent != null && (parentGroup = (Group)groups.get(this.m_parent.toLowerCase())) != null) {
            base = parentGroup.constructCapabilities(groups, capTable);
        }
        Util.addCapabilities(base, this.m_capabilities, capTable);
        return base;
    }

    public Set constructFeatureSet(Hashtable groups) {
        Group parentGroup;
        Set base = new TreeSet();
        if (this.m_parent != null && (parentGroup = (Group)groups.get(this.m_parent)) != null) {
            base = parentGroup.constructFeatureSet(groups);
        }
        base.addAll(this.m_features);
        return base;
    }
}

