/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna.post;

import de.pleumann.antenna.post.ClassFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DependencyChecker {
    private Vector classpath = new Vector();
    private Vector bootclasspath = new Vector();
    private Hashtable classes = new Hashtable();
    private Hashtable bootclasses = new Hashtable();

    public DependencyChecker(String classpath, String bootclasspath) {
        this.splitPath(classpath, this.classpath);
        this.splitPath(bootclasspath, this.bootclasspath);
    }

    public void destroy() {
        try {
            Object o;
            int i;
            for (i = 0; i < this.classpath.size(); ++i) {
                o = this.classpath.elementAt(i);
                if (!(o instanceof ZipFile)) continue;
                ((ZipFile)o).close();
            }
            for (i = 0; i < this.bootclasspath.size(); ++i) {
                o = this.bootclasspath.elementAt(i);
                if (!(o instanceof ZipFile)) continue;
                ((ZipFile)o).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void splitPath(String source, Vector target) {
        source = source + File.pathSeparatorChar;
        int p = 0;
        while (p < source.length()) {
            int q = source.indexOf(File.pathSeparator, p);
            String t = source.substring(p, q).trim();
            if (t.length() != 0) {
                File file = new File(t);
                if (file.isDirectory()) {
                    target.addElement(file);
                } else {
                    try {
                        target.addElement(new ZipFile(file));
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
            p = q + 1;
        }
    }

    public ClassFile loadClass(Vector classpath, String name) {
        for (int i = 0; i < classpath.size(); ++i) {
            ClassFile cf;
            Object o = classpath.elementAt(i);
            if (!(o instanceof File ? (cf = this.loadClassFromDir((File)o, name)) != null : (cf = this.loadClassFromZip((ZipFile)o, name)) != null)) continue;
            return cf;
        }
        return null;
    }

    public ClassFile loadClass(String name) throws ClassNotFoundException {
        ClassFile c = null;
        c = (ClassFile)this.classes.get(name);
        if (c != null) {
            return c;
        }
        c = (ClassFile)this.bootclasses.get(name);
        if (c != null) {
            return c;
        }
        c = this.loadClass(this.classpath, name);
        if (c != null) {
            this.classes.put(name, c);
            this.resolveClass(c);
            return c;
        }
        c = this.loadClass(this.bootclasspath, name);
        if (c != null) {
            this.bootclasses.put(name, c);
            this.resolveClass(c);
            return c;
        }
        throw new ClassNotFoundException(name);
    }

    private ClassFile loadClassFromZip(ZipFile zip, String name) {
        String realName = name.replace('.', '/') + ".class";
        ZipEntry entry = zip.getEntry(realName);
        if (entry != null) {
            try {
                return new ClassFile(zip.getInputStream(entry));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private ClassFile loadClassFromDir(File dir, String name) {
        String realName = name.replace('.', '/') + ".class";
        File file = new File(dir, realName);
        if (file.exists()) {
            try {
                return new ClassFile(new FileInputStream(file));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public void addRootClass(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.loadClass(name);
    }

    public Vector getClassNames() {
        Vector result = new Vector();
        Enumeration e = this.classes.keys();
        while (e.hasMoreElements()) {
            result.addElement(e.nextElement());
        }
        return result;
    }

    public void resolveClass(ClassFile cf) throws ClassNotFoundException {
        for (int i = 0; i < cf.getRequiredClassCount(); ++i) {
            this.loadClass(cf.getRequiredClass(i));
        }
    }
}

