package org.radeox.ant;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.radeox.api.engine.RenderEngine;
import org.radeox.api.engine.context.RenderContext;
import org.radeox.engine.BaseRenderEngine;
import org.radeox.engine.context.BaseRenderContext;


/**
 * omry 
 * 04/02/2008
 */
public class RadeoxAntTask extends Task
{
	private String m_inputFile;
	private String m_outputFile;
	private boolean m_verbose = false;

	
	public void setVerbose(boolean b)
	{
		m_verbose = b;
	}
	
	public void setInputFile(String file)
	{
		m_inputFile = file;
	}
	
	
	public void setOutputFile(String file)
	{
		m_outputFile = file;
	}
	
	public void execute() throws BuildException
	{
		if (m_inputFile == null) throw new BuildException("InputFile not specified");
		if (m_outputFile == null) throw new BuildException("OutputFile not specified");
		
	    RenderEngine engine = new BaseRenderEngine();
	    RenderContext context = new BaseRenderContext();
	    BufferedReader reader = null;
	    Writer writer = null;
	    try
		{
	    	reader = new BufferedReader(new InputStreamReader(new FileInputStream(m_inputFile)));
	    	writer = new OutputStreamWriter(new FileOutputStream(m_outputFile));
	    	if (m_verbose)
	    	{
	    		log(m_inputFile + " => " + m_outputFile);
	    	}
	    	String line = null;
	    	while((line = reader.readLine()) != null)
	    	{
	    		String out = engine.render(line, context);
	    		if (m_verbose)
	    		{
	    			log(out != null ? out : "null");
	    		}
	    		writer.write(out);
	    	}
		}
		catch (Exception e)
		{
			throw new BuildException(e);
		}
		finally
		{
			if (reader != null) 
			{
				try
				{
					reader.close();
				}
				catch (Exception e)
				{
				}
			}
			
			if (writer != null) 
			{
				try
				{
					writer.close();
				}
				catch (Exception e)
				{
				}
			}
			
		}
	}
}
