
package net.firefang.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * @author omry
 * Created on Nov 11, 2004
 */
public class File extends Task
{
	String m_result;
	String m_file;
	String m_op;
	
	/**
	 * @param file The file to set.
	 */
	public void setFile(String file)
	{
		m_file = file;
	}
	
	
	
	/**
	 * @param result The result to set.
	 */
	public void setResult(String result)
	{
		m_result = result;
	}
	
	/**
	 * @param op The op to set.
	 */
	public void setOp(String op)
	{
		if(op != null && 
		  (op.equalsIgnoreCase("abs") ||
		   op.equalsIgnoreCase("exists") || 
		   op.equalsIgnoreCase("mkdirs") ||
		   op.equalsIgnoreCase("dir_empty") ||
		   op.equalsIgnoreCase("isdir")))
		{
			m_op = op;
		}
		else
		{
			throw new IllegalArgumentException("Invalid op code " + op);
		}
	}
	
	
	/**
	 * @see org.apache.tools.ant.Task#execute()
	 */
	public void execute() throws BuildException
	{
		if (m_result == null && !m_op.equalsIgnoreCase("mkdirs"))
		{
			throw new BuildException("result property is not set");		
		}
		
		if (m_op == null)
		{
			throw new BuildException("op property is not set");		
		}
		
		
		if (m_file == null)
		{
			throw new BuildException("file not set");		
		}
		
		java.io.File file = new java.io.File(m_file);
		if (m_op.equalsIgnoreCase("abs"))
		{
			getProject().setProperty(m_result, file.getAbsolutePath());	
		}
		else
		if (m_op.equalsIgnoreCase("exists"))
		{
			getProject().setProperty(m_result, String.valueOf(file.exists()));	
		}
		else
		if (m_op.equalsIgnoreCase("isdir"))
		{
			boolean isDir = file.isDirectory();
		    getProject().setProperty(m_result, String.valueOf(isDir));
		}
		else
		if (m_op.equalsIgnoreCase("dir_empty"))
		{
			java.io.File[] files = file.listFiles();
			getProject().setProperty(m_result, String.valueOf(!file.exists() || files == null || files.length == 0));
		}
		else
		if (m_op.equalsIgnoreCase("mkdirs"))
		{
		    java.io.File parent;
		    if (m_file.endsWith("/") || m_file.endsWith("\\"))
		    {
		    	parent = file;
		    }
		    else
		    {
		    	parent = file.getParentFile();
		    }
		    log("Creating dirs for " + parent);
		    
		    if (parent != null)
		    {
		        parent.mkdirs();
		    }
		}
	}
}
