
package net.firefang.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * @author omry Created on Dec 1, 2004
 */
public class GetProperty extends Task
{
	String m_file;
	String m_name;
	String m_result;
	String m_default;
	boolean m_failIfNoFile;
	boolean m_failIfNoKey;
	
	public GetProperty()
	{
		m_default = null; // not set
		m_failIfNoFile = true;
		m_failIfNoKey = true;
	}

	/**
	 * @param failIfNoFile The failIfNoFile to set.
	 */
	public void setFailIfNoFile(boolean failIfNoFile)
	{
		m_failIfNoFile = failIfNoFile;
	}
	/**
	 * @param failIfNoKey The failIfNoKey to set.
	 */
	public void setFailIfNoKey(boolean failIfNoKey)
	{
		m_failIfNoKey = failIfNoKey;
	}
	/**
	 * @param file The file to set.
	 */
	public void setFile(String file)
	{
		m_file = file;
	}

	/**
	 * @param name The name to set.
	 */
	public void setName(String name)
	{
		m_name = name;
	}

	/**
	 * @param result The result to set.
	 */
	public void setResult(String result)
	{
		m_result = result;
	}

	/**
	 * @see org.apache.tools.ant.Task#execute()
	 */
	public void execute() throws BuildException
	{
		if(m_file == null)
		{
			throw new BuildException("missing file");
		}
		if(m_result == null)
		{
			throw new BuildException("missing result");
		}
		if(m_name == null)
		{
			throw new BuildException("missing name");
		}
		
		if (!(new File(m_file).exists()))
		{
			String msg = "Properties file " + m_file + " was not found";
			log(msg);
			if (m_failIfNoFile)
			{
				throw new BuildException(msg);
			}
			else
			{
				return;
			}
			
		}
		
		Properties props = new Properties();
		FileInputStream fin = null;
		try
		{
			fin = new FileInputStream(m_file);
			props.load(fin);
			String value = props.getProperty(m_name);
			if (value == null)
			{
				String msg = m_name + " was not found in " + m_file + " ( and no defualt is set)" ;
				log(msg);
				if (m_failIfNoKey && m_default == null)
				{
					throw new BuildException(msg);
				}
				else
				{
					value = m_default;
				}
			}
			
			getProject().setProperty(m_result, value);
		}
		catch (IOException e)
		{
			// file exists, so there must be something
			// very wrong if we got an io error.
			// fail anyway.
			throw new BuildException(e);
		}
		finally
		{
			if (fin != null)
			{
				try
				{
					fin.close();
				}
				catch (IOException e1)
				{
				}
			}
		}
		
	}
	
	/**
	 * @param defValue The default to set.
	 */
	public void setDefault(String defValue)
	{
		m_default = defValue;
	}
}