package net.firefang.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;


/**
 * omry 
 * 12/11/2007
 */
public class VirtualSymlinks extends Task
{
	String m_result;
	String m_file;
	
	/**
	 * @param file The file to set.
	 */
	public void setFile(String file)
	{
		m_file = file;
	}
	
	
	/**
	 * @param result The result to set.
	 */
	public void setResult(String result)
	{
		m_result = result;
	}
	/**
	 * @see org.apache.tools.ant.Task#execute()
	 */
	public void execute() throws BuildException
	{
		if (m_result == null)
		{
			throw new BuildException("result property is not set");		
		}
		
		if (m_file == null)
		{
			throw new BuildException("file not set");		
		}
		
		if (m_file.equals(""))
		{
			log("Empty file, returning empty result", Project.MSG_WARN);
			getProject().setProperty(m_result, "");
			return;
		}
		
		String file = m_file.replace("\\", "/"); // normalize
		String result = "";
		if (file.startsWith("/"))
		{
			result = "/";
		}
		
		StringTokenizer tok = new StringTokenizer(file, "/", true);
		try
		{
			while(tok.hasMoreElements())
			{
				String dir = tok.nextToken();
				if (dir.equals("/"))
				{
					result += dir;
					continue;
				}
				
				log("Inspecting " + result + dir, Project.MSG_DEBUG);
				String resolved = resolveDir(result, dir);
				if (!dir.equals(resolved))
				{
					log("Resolved " + result + dir + " -> " + result + resolved, Project.MSG_VERBOSE);
				}
				
				result += resolved;
			}
			
			String absRes = new java.io.File(result).getCanonicalFile().getAbsolutePath().replace("\\", "/");
			if (file.endsWith("/")) absRes += "/";
			String finalRes = absRes;
			if (!new File(m_file).isAbsolute())
			{
				String base = new java.io.File(".").getCanonicalFile().getAbsolutePath().replace("\\", "/") + "/";
				finalRes = absRes.substring(base.length());
			}
			
			boolean changed = (!new File(file).getCanonicalPath().equals(new File(finalRes).getCanonicalPath()));
			if (changed)
			{
				log("Followed " + file + " -> " + finalRes, Project.MSG_INFO);
			}
			getProject().setProperty(m_result, finalRes);	
		}
		catch (IOException e)
		{
			throw new BuildException("Error resolving virtual symlink " + m_file, e);
		}
	}


	private String resolveDir(String base, String dir) throws IOException
	{
		return resolveDir(base, dir, new Hashtable());
	}
	private String resolveDir(String base, String dir, Hashtable dirs) throws IOException
	{
		String abs = new java.io.File(base + dir).getAbsolutePath();
		if (dirs.containsKey(abs)) throw new BuildException("Links recursion detected");
		dirs.put(abs, abs);
		java.io.File f = new java.io.File(base + dir + ".link");
		if (f.exists())
		{
			String link = readLink(f);
			if (new java.io.File(link).isAbsolute()) throw new IOException("Absolute virtual symlinks are not supported");
			return resolveDir(base, link, dirs);
		}
		
		return dir;
	}


	private String readLink(File f) throws IOException
	{
		InputStream in = new FileInputStream(f);
		try
		{
			BufferedReader reader = new BufferedReader(new InputStreamReader(in));
			return reader.readLine();
		}
		finally
		{
			in.close();
		}
	}
}
