package net.firefang.ant.test;

import junit.framework.TestCase;
import net.firefang.ant.CreateEclipseTagList;
import net.firefang.ant.EclipseClasspath;

import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;


/**
 * omry 
 * 12/11/2007
 */
public class TestEclipseCPParser extends TestCase
{
	public void testExportedLibs()
	{
		EclipseClasspath ecp = new EclipseClasspath();
		ecp.setTaskName("Testing eclipse classpath parser");
		Project p = new Project();
		DefaultLogger defaultLogger = new DefaultLogger();
		defaultLogger.setMessageOutputLevel(Project.MSG_DEBUG);
		defaultLogger.setOutputPrintStream(System.out);
		p.addBuildListener(defaultLogger);
		ecp.setProject(p);
		ecp.setRootDir("src/net/firefang/ant/test");
		ecp.setProject("test_project");
		ecp.setResult("result");
		
		ecp.setAction("only_exported_libs");
		ecp.execute();
		assertEquals("test_project/some_exported_jar1.jar;test_project/some_exported_jar2.jar", p.getProperty("result"));
		
		ecp.setAction("libs");
		ecp.execute();
		assertEquals("test_project/a_lib.jar;test_project/some_exported_jar1.jar;test_project/some_exported_jar2.jar", p.getProperty("result"));
		
		ecp.setAction("projects");
		ecp.setProject("test_project2");
		ecp.execute();
		assertEquals("test_project3,Client Resources", p.getProperty("result"));
	}
	
	public void testTagList()
	{
		CreateEclipseTagList etl = new CreateEclipseTagList();
		etl.setTaskName("Testing eclipse tag list creator");
		Project p = new Project();
		DefaultLogger defaultLogger = new DefaultLogger();
		defaultLogger.setMessageOutputLevel(Project.MSG_DEBUG);
		defaultLogger.setOutputPrintStream(System.out);
		p.addBuildListener(defaultLogger);
		etl.setProject(p);
		etl.setRootDir("src/net/firefang/ant/test");
		etl.setEntryProject("test_project2");
		etl.setResult("result");
		etl.execute();
		assertEquals("Client Resources,test_project3,test_project2", p.getProperty("result"));
	
	}
}
