package net.firefang.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

/**
 * @author omry
 * Created on Nov 11, 2004
 * 
 * Creates a semicolon seperated list of files based 
 * on include and exclude parameters. 
 */
public class FilesList extends Task
{
	String m_result;
	String m_dir;
	String m_includes;
	String m_excludes;
	
	public FilesList()
	{
		// default include.
		m_includes = "*.*";
	}
	
	/**
	 * @param dir The dir to set.
	 */
	public void setDir(String dir)
	{
		m_dir = dir;
	}
	
	
	/**
	 * @param includes The includes to set.
	 */
	public void setIncludes(String includes)
	{
		m_includes = includes;
	}
	
	
	/**
	 * @param excludes The excludes to set.
	 */
	public void setExcludes(String excludes)
	{
		m_excludes = excludes;
	}
	
	
	
	/**
	 * @param result The result to set.
	 */
	public void setResult(String result)
	{
		m_result = result;
	}
	
	
	/**
	 * @see org.apache.tools.ant.Task#execute()
	 */
	public void execute() throws BuildException
	{
		try
		{
			if(m_result == null)
			{
				throw new BuildException("result property is not set");
			}

			if(m_dir == null)
			{
				throw new BuildException("dir not set");
			}

			FileSet fs = new FileSet();
			fs.setProject(getProject());
			fs.setDir(new java.io.File(m_dir));
			fs.setIncludes(m_includes);
			fs.setExcludes(m_excludes);
			getProject().setProperty(m_result, fs.toString());
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new BuildException(e);
		}
	}
}
