package net.firefang.ant;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * @author omry
 * Created on Dec 1, 2004
 */
public class RMDups extends Task
{
	/**
	 * Input list to remove dups from
	 */
	private Vector m_lists;
	private String m_outDelim;
	private String m_result;
	
	public RMDups()
	{
		m_lists = new Vector();
		m_outDelim = ",";
	}
	
	/**
	 * @param outDelim The outDelim to set.
	 */
	public void setOutDelim(String outDelim)
	{
		m_outDelim = outDelim;
	}
	

	
	/**
	 * @param result The name of the result property to set.
	 */
	public void setResult(String result)
	{
		m_result = result;
	}
	
	/**
	 * Merges the lists into ${outputname} is a stable way.
	 */
	public void execute() throws BuildException
	{
		if (m_result == null)
		{
			throw new BuildException("result is not specified");
		}
		
		
		int numLists = m_lists.size();
		StringTokenizer st[] = new StringTokenizer[numLists];
		for (int i = 0; i < st.length; i++)
		{
			List list = (List) m_lists.elementAt(i);
			String delim;
			if (list.m_delim == null)
			{
				delim = m_outDelim;
			}
			else
			{
				delim = list.m_delim;
			}
			
			st[i] = new StringTokenizer(list.m_list, delim);
		}
		
		Hashtable foundMap = new Hashtable();
		StringBuffer sb = new StringBuffer();
		while (true)
		{
			boolean allEmpty = true;
			for (int i = 0; i < st.length; i++)
			{
				if (st[i].hasMoreElements())
				{
					allEmpty = false;
					String tok = st[i].nextToken();
					if (!foundMap.containsKey(tok)) // new item ?
					{
						foundMap.put(tok, tok);
						sb.append(tok).append(m_outDelim);
					}
				}
			}
			
			if (allEmpty)
			{
				break;
			}
		}
		
		String sbs = sb.toString();
		if (sbs.endsWith(m_outDelim))
		{
			sbs = sbs.substring(0, sbs.length() - m_outDelim.length());
		}
		
		getProject().setProperty(m_result, sbs);
	}
	
	public List createList()
	{
		List list = new List();
		addList(list);
		return list;
	}
	
	public void addList(List list)
	{
		m_lists.addElement(list);
	}
	
	
	public static class List 
	{
		String m_list;
		String m_delim;
		
		public List()
		{
			m_delim = null;
		}
		
		public List(String list, String delim)
		{
			m_list = list;
			m_delim = delim;
		}
		
		/**
		 * @param delim The delim to set.
		 */
		public void setDelim(String delim)
		{
			m_delim = delim;
		}
		/**
		 * @param list The list to set.
		 */
		public void setList(String list)
		{
			m_list = list;
		}
	}
}

