<html>

		<?php require_once('header.php')?>

		<!-- =============================================================== -->

		<a name="news"/>
		<h2>News</h2>
		
		Antenna 1.0.1
		Changes:
		<ul> 
			<li>Added an option to exclude specific jad options from Manifest</li>
			<li><b>Preprocessor related</b>
			    <ul>
				<li>Its now possible to set the debug level of the wtkpreprocess task directly</li>
				<li>Added the ability to load symbol files into the preprocessor</li>
				<li>Can now save used symbols list to file</li>
				<li>Fixed an encoding problem in the preprocessor for non ascii files (Effects both Antenna and the Eclipse plugin)</li>
				<li>WtkPreprocess: added a parameter to specify devices database directory - devicedbpath</li>
				<li>Preprocessor eclipse plugin: Added UI to select device database directory inside workspace</li>
				<li>Fixed the parser of the devices.xml to properly handle devices which apply to multiple devices (with a device name that is comma separated list of device names)</li>
				<li>Added the ability to override devices in the internal device.xml by putting a file named <b>custom-devices.xml</b> in the working directory or lib directory under the working directory</li>
				<li>Fixed //#if to treat symbols with the strings "true" and "false" as boolean values</li>
				<li>Fixed parse errors in some cases in the expand directive</li>
				<li>Fixed parse errors in some cases in the include directive</li>
			    </ul>
			</li>
			
		</ul>
		
		Antenna 1.0.0. is out
		This is a bugfix release of 0.9.15, the bump in version number is due to a mistake with the version number of the previous release.
		The following things have been fixed:
		<ul>
			<li>fixed to replace ant Ant symbols in preprocessor symbols</li>
			<li>fixed path problem when running preverify on Ubuntu</li>
			<li>fixed a bug with the expand preprocessor directive</li>
			<li>Fixed a bug in the source distrubiton build</li>
			<li>The new preprocessor was moved to a new CVS project (<b>antenna.preprocessor</b>) and is available under LGPL or EPL licenses</li>
		</ul>
		
		
		Antenna 0.9.15-beta is out!
		There are several new features and improvements in this release which was contributed by <b>Omry Yadan</b>, who joined the project recently
		<ul>
			<li><a href="wtkpreprocess.php">New preprocessor</a> backend with variables support, as well as device database integration and eclipse plugin</li>
			<li><a href="wtksign.php">WtkSign</a> introduced</li>
			<li>Added the ability to select a JAD from a directory with a UI to <a href="wtkrun.php">WtkRun</a></li>
		</ul>

		<a name="synopsis"/>
		<h2>Overview</h2>
		
		Antenna provides a set of <a href="http://jakarta.apache.org/ant">Ant</a>
		tasks suitable for developing wireless Java applications targeted at the
		<a href="http://java.sun.com/products/midp">Mobile Information Device Profile</a>
		(MIDP). With Antenna, you can compile, preverify, package, obfuscate, and run your
		MIDP applications (aka MIDlets), manipulate Java Application Descriptor (JAD) files,
		as well as convert JAR files to PRC files designed to
		run on the MIDP for PalmOS implementations from <a href="http://java.sun.com/products/midp4palm">Sun</a>
		and <a href="http://pluggedin.palmone.com/regac/pluggedin/Java.jsp">IBM</a>.
		Deployment is supported via a deployment task and a corresponding HTTP servlet
		for Over-the-Air (OTA) provisioning. A small preprocessor allows to generate
		different variants of a MIDlet from a single source.
		
		<p />
		
		Of course you can also do much of that with the
		<a href="http://java.sun.com/products/j2mewtoolkit">J2ME Wireless Toolkit</a>
		or other 
		Java IDEs, but using an Ant script results in a defined and reproducable build
		process that is independent of a particular programming environment. See
		<a href="http://www.javaworld.com/javaworld/jw-10-2000/jw-1020-ant.html">
		this article</a> for an excellent introduction to Ant as well as reasons for using it.
		
		<p />
		
		The Antenna tasks are mostly built around functionality provided by the
		Wireless Toolkit and thus require this software. If you want to make use of
		the obfuscation task, you should have one (or both) of the free
		<a href="http://www.retrologic.com">RetroGuard</a> and
		<a href="http://proguard.sourceforge.net">ProGuard</a> obfuscators on your
		harddisk. Naturally, Ant itself is also needed, where
		version 1.5.0 seems to be the minimum required version as reported by users.
		Antenna works very well in Ant-supportive IDEs like
		<a href="http://www.eclipse.org">Eclipse</a> or
		<a href="http://www.jedit.org">JEdit</a>.

		<p />
		
		Here is a list of tasks contained in the package:
		
		<p />

		<table class="color">
			<tr>
				<th>
		  			Task
		  		</th>

				<th>
		  			Purpose
		  		</th>
			</tr>

			<tr>
				<td>
					<a href="wtkjad.php">WtkJad</a>
				</td>

				<td>
		  		    A task that is able to create new JAD
		  		    files from scratch or update existing ones.
		  		</td>

			</tr>

			<tr>
				<td>
					<a href="wtkbuild.php">WtkBuild</a>
				</td>

				<td>
		  			An extension to Ant's standard javac task that sets
		      		the appropriate bootclasspath allows for preverification.
		        </td>

			</tr>

			<tr>
				<td>
					<a href="wtkpackage.php">WtkPackage</a>
				</td>

				<td>
		    		An extension to Ant's standard jar task that handles
		    		the JAD file correctly and is able to
			    	include complete libraries into the resulting JAR file. It also
			    	allows for preverification and obfuscation of the generated file.
			    </td>
			</tr>

			<tr>
				<td>
					<a href="wtkmakeprc.php">WtkMakePrc</a>
				</td>

				<td>
		    		A task to convert an existing JAR/JAD into a PalmOS PRC
		    		file that can be used with MIDP for Palm OS.
		    	</td>
			</tr>

			<tr>
				<td>
					<a href="wtkrun.php">WtkRun</a>
				</td>

				<td>
		    		A task to run a MIDlet suite contained in a JAR/JAD file
		    		in the Wireless Toolkit's emulator.
		    	</td>
			</tr>

			<tr>
				<td>
					<a href="wtkrapc.php">WtkRapc</a>
				</td>

				<td>
		  		    A task that invokes the BlackBerry <code>rapc</code> compiler, and generates BlackBerry <code>.cod</code> files.
		  		</td>

			</tr>

			<tr>
				<td>
					<a href="wtkpreverify.php">WtkPreverify</a>
				</td>

				<td>
		    		A standalone task for preverifying a set of classes. This task
		    		is normally not needed, since the build and packaging
		    		tasks include the same functionality.
		    	</td>

			</tr>

			<tr>
				<td>
					<a href="wtkobfuscate.php">WtkObfuscate</a>
				</td>

				<td>
		    		A standalone task for obfuscating a JAR file. This task is normally not
		    		needed, since the packaging task includes the same functionality.
		    	</td>
			</tr>

			<tr>
				<td>
					<a href="wtksmartlink.php">WtkSmartLink</a>
				</td>

				<td>
		    		A task for removing unnecessary classes from a JAR file.
		    	</td>
			</tr>

			<tr>
				<td>
					<a href="wtkpreprocess.php">WtkPreprocess</a>
				</td>

				<td>
		    		A simple Java preprocessor, similar to the ones known from C and
		    		other languages, that allows for conditional compilation and
		    		including source files.
		    	</td>
			</tr>

			<tr>
				<td>
					<a href="wtkdeploy.php">WtkDeploy</a>
				</td>

				<td>
		    		A deployment task that allows to put a MIDlet on a remote
		    		Web server for later download.
		    	</td>
			</tr>
			
			<tr>
				<td>
					<a href="wtksign.php">WtkSign</a>
				</td>

				<td>
					A task for signing midlets
		    	</td>
			</tr>
			

		</table>

        <p/>
        

		<h3>Samples</h3>
		
		There are several sample build.xml files in the "samples" subdirectory of the
		Antenna source distribution. These files show how to build the default demo MIDlets
		contained in the Wireless Toolkit and some others. Running the samples is a good way
		to test your setup as well as a good starting point for your own build.xml files.
		

		The Antenna project is hosted on
		<a href="http://www.sourceforge.net/projects/antenna">SourceForge</a> and
		distributed under the <a href="http://www.gnu.org/licenses/lgpl.txt">GNU
		Lesser General Public License</a> (LGPL). You can download the most recent
		version  <a href="http://sourceforge.net/project/showfiles.php?group_id=67420">here</a>.
		
		<p />

		<h3>Mailing List</h3>

	    There's also a mailing list for discussing Antenna.
	    You can subscribe to the list <a href="http://sourceforge.net/mail/?group_id=67420">here</a>,<br/>
	    list archives are available <a href="http://sourceforge.net/mailarchive/forum.php?forum_name=antenna-discussion">here</a>

		<p />

		<a name="contact" />
		<h3>Contact</h3>
		
		If you find Antenna useful, you might want to send a picture postcard
		of your hometown or country telling me so. My surface mail address is:
		Jצrg Pleumann, Amselstrasse 41, D-45472 M�lheim, Germany. E-mails are also
		fine, but don't underestimate the productivity (and ego) boost that a wall
		full of postcards next to my desk will cause. :)
		
		<p />

		<hr />

		<!-- =============================================================== -->

		<a name="setup" />
		<h2>Setup</h2>

		Setting up Antenna is rather straightforward. The first thing you want
		to do is either put the Antenna JAR file into Ant's lib directory or your
		classpath. Then there's a number of properties you might want to adjust to
		your needs, either in each build.xml file you use or in a global file that
		is imported in the specific build.xml files. 
        <pre>
&lt;taskdef resource="antenna.properties"/&gt;
		</pre>

		If you don't want to put Antenna into your classpath, the following variant should
		also work:

        <pre>
&lt;taskdef resource="antenna.properties" classpath="full name of Antenna jar file"/&gt;
		</pre>
		
		<h3>Selecting a WTK and APIs for a project</h3>

		All Antenna tasks rely on a property "wtk.home" that points to the directory
		where the Wireless Toolkit has been installed. So, if your WTK resides in
		"c:\Java\wtk-1.0.4", you need to add the following line to your build scripts:
		
		<p />

		<pre>
&lt;property name="wtk.home" value="c:\Java\wtk-1.0.4"/&gt;
		</pre>

		Depending on the WTK version you are using, a different set of base and
		extension APIs is available for your MIDlets. Antenna automatically detects
		your WTK version and selects APIs according to the following simple rule:
		The default BOOTCLASSPATH consists of CLDC-1.0 and MIDP 1.0 with no
		extension APIs. If your want to change these settings, you can do so by
	    using the following properties (the "WTK" column specifies WTK version
		required for this property to be taken into account):

		<p />

		<table class="color">
			<tr>
				<th>
		  			Property
		  		</th>

				<th>
		  			Default
		  		</th>

				<th>
		  			Purpose
		  		</th>

				<th>
		  			WTK
		  		</th>
			</tr>

			<tr>
				<td>
		    		wtk.cldc.version
		    	</td>

				<td>
		    		1.0
		    	</td>

				<td>
		    		Specifies the version of CLDC to use.
		    	</td>

				<td>
		    		2.1+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.midp.version
		    	</td>

				<td>
		    		2.0 for WTK 2.x, 1.0 otherwise.
		    	</td>

				<td>
		    		Specifies the version of MIDP to use.
		    	</td>

				<td>
		    		2.0+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.mmapi.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the Multimedia API (MMAPI).
		    	</td>

				<td>
		    		2.0+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.wma.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the Wireless Messaging API (WMA).
		    	</td>

				<td>
		    		2.0+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.wma.version
		    	</td>

				<td>
		    		1.0
		    	</td>

				<td>
		    		Selects the supported version of the Wireless Messaging API (WMA).
		    		Currently either 1.0 (JSR-120) or 2.0 (JSR-205) is allowed.
		    	</td>

				<td>
		    		2.3+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.j2mews.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME Web Services API (J2MEWS).
		    	</td>

				<td>
		    		2.1+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.bluetooth.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME Bluetooth API (JSR-82).
		    	</td>

				<td>
		    		2.2+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.java3d.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME 3D API (JSR-184).
		    	</td>

				<td>
		    		2.2+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.optionalpda.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME optional PDA packages (JSR-75).
		    	</td>

				<td>
		    		2.2+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.locationservices.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME location services API (JSR-179).
		    	</td>

				<td>
		    		2.3+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.contenthandler.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME content handler API (JSR-211).
		    	</td>

				<td>
		    		2.3+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.satsa.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME Security and Trust Services API (JSR-177).
		    	</td>

				<td>
		    		2.3+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.miapi.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME Mobile Internationalization API (JSR-238).
		    	</td>

				<td>
		    		2.5+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.ams.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME Advanced Multimedia Supplements API (JSR-234).
		    	</td>

				<td>
		    		2.5+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.papi.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME Payment API (JSR-229).
		    	</td>

				<td>
		    		2.5+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.s2dvgapi.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME Scalable 2D Vector Graphics API (JSR-226).
		    	</td>

				<td>
		    		2.5+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.sipapi.enabled
		    	</td>

				<td>
		    		false
		    	</td>

				<td>
		    		Enables or disables the J2ME Session Initiation Protocol API (JSR-180).
		    	</td>

				<td>
		    		2.5+
		    	</td>
			</tr>

			<tr>
				<td>
		    		wtk.midpapi
		    	</td>

				<td>
		    		Varies
		    	</td>

				<td>
					Sets a totally custom BOOTCLASSPATH. Use this property if the set
					of APIs you need is not covered by the above properties (for
					example because you are using the system libraries provided
					another vendor or you have some important additional libraries).
		    	</td>

				<td>
		    		1.0+
		    	</td>
			</tr>
		</table>

		<p />

		Please note that the properties for selecting a CLDC and MIDP version also
		set the default values for the "config" and "profile" properties used in the
        WtkJad and WtkPackage tasks. So, if you set the versions properly at the
		beginning of your build.xml file, you normally don't have to deal with
		these values again.

		<p />

		<h3>Using the Websphere Micro Environment Toolkit for PalmOS</h3>
		
		Starting from version 0.9.11, Antenna also supports the PRC converter
		from the <a href="http://pluggedin.palmone.com/regac/pluggedin/Java.jsp">IBM
		Websphere Micro Environment Toolkit for PalmOS</a> (WME). This converter
		is needed to generate PRC files for IBM J9 VM that runs on the new Tungsten devices.
		To use it, specify the WME's home directory as follows:
		
		<pre>
&lt;property name="wtk.wme.home" value="your path goes here"/&gt;
		</pre>
		
		The current release of the WME already supports CLDC 1.1 and MIDP 2.0 plus
		some extension APIs. The MIDP for PalmOS from Sun, in contrast, seems to
		be pretty much dead. Please note that the name of this property has changed
		with Antenna 0.9.12 for reasons of consistency.

		<a name="ota" />
		<h3>Using Over-the-Air provisioning</h3>
		
		In addition to the various Ant tasks, the project also provides a simple
		servlet for OTA provisioning of MIDlet suites. This servlet
		is included in the same ZIP file as the tasks. It allows to upload MIDlet
		suites via the <a href="#deploy">WtkDeploy</a> task. Once uploaded,
		a MIDlet suite can be downloaded by WWW and WAP clients. Lists of
		available suites can be retrieved in HTML and WML. The format of these
		lists can be modified using a template mechanism.
		
		<p />
		
		The following steps are necessary to run the OTA servlet:
		
		<ol>

			<li>
		        Install a servlet-capable Web server, preferredly
		        <a href="http://jakarta.apache.org/tomcat">Tomcat</a>.
		    </li>

			<li>
		        Add a new Web application, for example by creating
		        a directory "antenna" under "&lt;tomcat&gt;/webapps".
		        Create a directory "WEB-INF" and a subdirectory 
		        "WEB-INF/lib" there.
		    </li>

			<li>
		        Copy the "web.xml" file from the "etc" directory of the
		        Antenna source distribution (or from CVS) to "WEB-INF" and
		        adjust it to your personal needs. Copy the "antenna-bin.jar"
		        binary distribution file to "WEB-INF/lib".
		    </li>

			<li>
		        You should have a working configuration now. Test it by
		        starting Tomcat and accessing the servlet using a Web
		        browser or the Wireless Toolkit's OTA provisioning
		        mechanism. If the servlet URL is "http://localhost/antenna",
		        the HTML and WML pages are available as "http://localhost/antenna/index.html"
		        and "http://localhost/antenna/index.wml", respectively. When
		        only the directory is specified, the servlet tries to determine
		        the correct version from the HTTP request headers.
		    </li>

			<li>
		        Test deployment by running the "deploy" sample (modify "build.xml"
		        first).
		    </li>

			<li>
		        To create your own layout for the pages, copy the two files from
		        the "res" directory of the Antenna source distribution (or from CVS)
		        to "WEB-INF" and modify them. There's
		        documentation inside the "index.html" file that tells you how to
		        do this.
		    </li>

		</ol>
		
		If you are running the OTA servlet with modified templates, it would be nice
		if you added a small hyperlink saying "Powered by Antenna" (pointing to the
		project's homepage) to the bottom of the page. Same if you modify the servlet
		itself.

        <p />
        
        A running version of the servlet should be available on 
        <a href="http://pleumann.dyndns.org/antenna">my home machine</a>.
        

		<center>
			<a href="http://sourceforge.net">
				<img src="http://sourceforge.net/sflogo.php?group_id=67420&amp;&amp;type=2" width="125" height="37" border="0" alt="SourceForge.net Logo" />
			</a>
		</center>

	</body>

	<a name="bottom" />
</html>