
package net.firefang.ant;



import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * @author omry
 */
public class EclipseClasspath extends Task
{

	private String m_rootDir = ".";
	private String m_project;
	private String m_action;
	private String m_result;
	private String m_exclude;
	

	/**
	 * @see org.apache.tools.ant.Task#execute()
	 */
	public void execute() throws BuildException
	{
		check();
		
		if(m_action.equals("src"))
		{
			String srcPaths[] = EclipseCPParse.getSourcePaths(m_rootDir, m_project, m_exclude);
			getProject().setProperty(m_result, toString(srcPaths, ";"));
		}
		else if(m_action.equals("libs"))
		{
			String libs[] = EclipseCPParse.getLibs(m_rootDir, m_project, m_exclude, false, false);
			getProject().setProperty(m_result, toString(libs, ";"));
		}
		else if(m_action.equals("only_exported_libs"))
		{
			String libs[] = EclipseCPParse.getLibs(m_rootDir, m_project, m_exclude, true, false);
			getProject().setProperty(m_result, toString(libs, ";"));
		}
		else if(m_action.equals("projects"))
		{
			String projList[] = EclipseCPParse.getDependProjects(m_rootDir, m_project, m_exclude);
			getProject().setProperty(m_result, toString(projList, ","));
		}
	}

	private void check()
	{
		if(m_action == null)
		{
			throw new BuildException(
					"Missing action (possible values : [src | libs | projects])");
		}
		
		if (m_project == null)
		{
			throw new BuildException("Missing project name");
		}
		
		if (m_result == null)
		{
			throw new BuildException("Missing result name");
		}
	}
	
	public void setExclude(String list)
	{
		m_exclude = list;
	}

	public void setAction(String action)
	{
		m_action = action;
	}

	public void setProject(String project)
	{
		m_project = project;
	}

	public void setRootDir(String rootDir)
	{
		m_rootDir = rootDir;
	}
	
	public void setResult(String result)
	{
		m_result = result;
	}
	
	static String toString(String s[], String sep)
	{
		StringBuffer sb = new StringBuffer();
		int size = s.length;
		for (int i = 0; i < size; i++)
		{
			sb.append(s[i]);
			if (i < size - 1)
			{
				sb.append(sep);
			}
		}
		String projList = sb.toString();
		return projList;
	}
	
}
