package net.firefang.ant.test;

import net.firefang.ant.RMDups;

import org.apache.tools.ant.Project;


import junit.framework.TestCase;

/**
 * @author omry
 * Created on Dec 1, 2004
 */
public class RMDupsTest extends TestCase
{

	public void testExecute1()
	{
		RMDups dups = new RMDups();
		Project project = new Project();
		dups.setProject(project);
		String outname = "OUTPUT";
		dups.setResult(outname);
		dups.addList(new RMDups.List("A,B,C", ","));
		dups.execute();
		String result = project.getProperty(outname);
		assertEquals("A,B,C", result);
	}
	
	public void testExecute2()
	{
		RMDups dups = new RMDups();
		Project project = new Project();
		dups.setProject(project);
		String outname = "OUTPUT";
		dups.setResult(outname);
		dups.setOutDelim("*");
		dups.addList(new RMDups.List("A,B,C", ","));
		dups.addList(new RMDups.List("A.B.D", "."));
		dups.execute();
		String result = project.getProperty(outname);
		assertEquals("A*B*C*D", result);
	}	
	
	public void testExecute3()
	{
		RMDups dups = new RMDups();
		Project project = new Project();
		dups.setProject(project);
		String outname = "OUTPUT";
		dups.setResult(outname);
		dups.setOutDelim(" ");
		dups.addList(new RMDups.List("A,B,C", ","));
		dups.addList(new RMDups.List("A.B.D.E", "."));
		dups.addList(new RMDups.List("E;X;T", ";"));
		dups.execute();
		String result = project.getProperty(outname);
		assertEquals("A E B X C D T", result);
	}	
}
