
package net.firefang.ant;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * @author omry Creates a list sorted by reverse bfs from a tree. used to create
 *         projects build order from a dependency graph.
 */
public class CreateEclipseBuildList extends Task
{
	private String m_rootDir = ".";
	private String m_entryProject;
	private String m_result;

	/**
	 * @param rootDir sets the root directory. defaults to "."
	 */
	public void setRootDir(String rootDir)
	{
		m_rootDir = rootDir;
	}

	/**
	 * @see org.apache.tools.ant.Task#execute()
	 */
	public void execute() throws BuildException
	{
		if(m_entryProject == null)
		{
			throw new BuildException("missing entry project Key");
		}

		if(m_result == null)
		{
			throw new BuildException("result key is not specified");
		}

		// BFS sort
		Vector resultVector = new Vector();
		LinkedList queue = new LinkedList();
		Hashtable uniqueProjects = new Hashtable();
		int depth = 0;
		String first = m_entryProject;
		uniqueProjects.put(first, first);
		queue.addLast(new Project("None", first));
		queue.addLast(DEPTH_FLAG);
		while (!queue.isEmpty())
		{
			Project project = (Project) queue.removeFirst();
			if(project == DEPTH_FLAG)
			{
				depth++;
				continue;
			}

			if(depth > uniqueProjects.size())
			{
				throw new BuildException("Circular dependency detected");
			}

			String children[] = EclipseCPParse.getDependProjects(m_rootDir, project.m_name, null);
			for (int i = 0; i < children.length; i++)
			{
				queue.addLast(new Project(project.m_name, children[i]));
			}

			Object next = queue.getFirst();
			if(next == DEPTH_FLAG)
			{
				queue.addLast(DEPTH_FLAG);
			}

			uniqueProjects.put(project.m_name, project.m_name);
			resultVector.addElement(project.m_name);
		}

		getProject().setProperty(m_result, toList(resultVector, ","));
	}

	/**
	 * @param resultVector
	 * @return
	 */
	private String toList(Vector resultVector, String sep)
	{
		StringBuffer b = new StringBuffer();
		Hashtable t = new Hashtable();
		for (int i = resultVector.size() - 1; i >= 0; i--)
		{
			Object object = resultVector.elementAt(i);
			if(!t.containsKey(object))
			{
				t.put(object, object);
				b.append(object);
				if(i > 0)
				{
					b.append(sep);
				}
			}
		}
		String list = b.toString();
		return list;
	}

	// private String[] getChildren(String file, String parent)
	// {
	// if(!(new File(file).exists()))
	// {
	// String msg = "Properties file " + file + " was not found (parent "
	// + parent + ")";
	// throw new BuildException(msg);
	// }
	//
	// Properties props = new Properties();
	// FileInputStream fin = null;
	// try
	// {
	// fin = new FileInputStream(file);
	// props.load(fin);
	// String value = props.getProperty(m_name);
	// if(value == null)
	// {
	// String msg = m_name + " was not found in " + file;
	// log(msg);
	// throw new BuildException(msg);
	// }
	// return tokenizeString(value, ", ");
	// }
	// catch (IOException e)
	// {
	// // file exists, so there must be something
	// // very wrong if we got an io error.
	// // fail anyway.
	// throw new BuildException(e);
	// }
	// finally
	// {
	// if(fin != null)
	// {
	// try
	// {
	// fin.close();
	// }
	// catch (IOException e1)
	// {
	// }
	// }
	// }
	// }
	//
	// public static String[] tokenizeString(String str, String delimiters)
	// {
	// StringTokenizer tokenizer = new StringTokenizer(str, delimiters);
	// String[] tokens = new String[tokenizer.countTokens()];
	// int i = 0;
	//
	// while (tokenizer.hasMoreTokens())
	// {
	// tokens[i++] = tokenizer.nextToken();
	// }
	//
	// return tokens;
	// }

	public void setEntryProject(String entryProject)
	{
		m_entryProject = entryProject;
	}

	/**
	 * Sets the name of the result property. the result property will contain a
	 * comma seperated list of items sorted in reverse order by depth.
	 * 
	 * @param result
	 */
	public void setResult(String result)
	{
		m_result = result;
	}

	private static class Project
	{
		/**
		 * @param parentProject
		 * @param name
		 */
		public Project(String parentProject, String name)
		{
			super();
			m_parentProject = parentProject;
			m_name = name;
		}

		String m_parentProject;
		String m_name;

		/**
		 * @see java.lang.Object#toString()
		 */
		public String toString()
		{
			return m_name + " (parent : " + m_parentProject + ")";
		}
	}

	private static final Project DEPTH_FLAG = new Project(null, null)
	{
		/**
		 * @see java.lang.Object#toString()
		 */
		public String toString()
		{
			return "DEPTH_FLAG";
		}
	};
}
