
package net.firefang.ant;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

/**
 * @author omry Creates a list of projects and jars to tag.
 */
public class CreateEclipseTagList extends Task
{
	private String m_rootDir = ".";
	private String m_entryProject;
	private String m_result;
	private String m_excludeList;

	/**
	 * @param rootDir sets the root directory. defaults to "."
	 */
	public void setRootDir(String rootDir)
	{
		m_rootDir = rootDir;
	}

	/**
	 * @see org.apache.tools.ant.Task#execute()
	 */
	public void execute() throws BuildException
	{
		if(m_entryProject == null)
		{
			throw new BuildException("missing entry project Key");
		}

		if(m_result == null)
		{
			throw new BuildException("result key is not specified");
		}

		// BFS sort
		Vector resultVector = new Vector();
		LinkedList queue = new LinkedList();
		Hashtable uniqueProjects = new Hashtable();
		int depth = 0;
		String first = m_entryProject;
		uniqueProjects.put(first, first);
		queue.addLast(new Project("None", first));
		queue.addLast(DEPTH_FLAG);
		while (!queue.isEmpty())
		{
			Project project = (Project) queue.removeFirst();
			if(project == DEPTH_FLAG)
			{
				depth++;
				continue;
			}
			
			if(depth > uniqueProjects.size())
			{
				throw new BuildException("Circular dependency detected");
			}

			String children[] = EclipseCPParse.getDependProjects(m_rootDir, project.m_name, null);
			for (int i = 0; i < children.length; i++)
			{
				queue.addLast(new Project(project.m_name, children[i]));
			}
			
			String[] libs = EclipseCPParse.getLibs(m_rootDir, project.m_name, null, false, true);
			for (int i = 0; i < libs.length; i++)
			{
				resultVector.addElement(libs[i]);
			}
			
			if(queue.getFirst() == DEPTH_FLAG)
			{
				queue.addLast(DEPTH_FLAG);
			}

			uniqueProjects.put(project.m_name, project.m_name);
			resultVector.addElement(project.m_name);
		}
		
		getProject().setProperty(m_result, toList(resultVector, ","));
	}

	/**
	 * @param resultVector
	 * @return
	 */
	private String toList(Vector resultVector, String sep)
	{
		StringBuffer b = new StringBuffer();
		Hashtable t = new Hashtable();
		for (int i = resultVector.size() - 1; i >= 0; i--)
		{
			Object object = resultVector.elementAt(i);
			if(!t.containsKey(object))
			{
				t.put(object, object);
				b.append(object);
				if(i > 0)
				{
					b.append(sep);
				}
			}
		}
		String list = b.toString();
		return list;
	}


	public void setEntryProject(String entryProject)
	{
		m_entryProject = entryProject;
	}

	/**
	 * Sets the name of the result property. the result property will contain a
	 * comma seperated list of items sorted in reverse order by depth.
	 * 
	 * @param result
	 */
	public void setResult(String result)
	{
		m_result = result;
	}

	private static class Project
	{
		/**
		 * @param parentProject
		 * @param name
		 */
		public Project(String parentProject, String name)
		{
			super();
			m_parentProject = parentProject;
			m_name = name;
		}

		String m_parentProject;
		String m_name;

		/**
		 * @see java.lang.Object#toString()
		 */
		public String toString()
		{
			return m_name + " (parent : " + m_parentProject + ")";
		}
	}

	private static final Project DEPTH_FLAG = new Project(null, null)
	{
		/**
		 * @see java.lang.Object#toString()
		 */
		public String toString()
		{
			return "DEPTH_FLAG";
		}
	};
}
