package net.firefang.ant;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.tools.ant.BuildException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * @author omry
 */
public class EclipseCPParse
{
    public static String[] getLibs(String rootDir, String project, String excludeList, boolean onlyExportedLibs, boolean excludeLibsInProject)
            throws BuildException
    {
        String cpfilePath = rootDir + File.separatorChar + project
                + File.separatorChar + ".classpath";
        if (!new File(cpfilePath).exists())
        {
        	System.err.println("getLibs: file not found " + cpfilePath);
        	return new String[0];
        }
        
        try
        {
        	Vector exclude = listToVector(excludeList);
            Element cpfile = XMLUtils.parseXmlFile(cpfilePath);
            NodeList entries = cpfile.getElementsByTagName("classpathentry");
            int len = entries.getLength();
            Vector v = new Vector();
            for (int i = 0; i < len; i++)
            {
                Element element = (Element) entries.item(i);
                String kind = element.getAttribute("kind");
                
                String path = element.getAttribute("path");
                if (kind.equals("lib") && !exclude.contains(path))
                {
                	boolean isExported = "true".equals(element.getAttribute("exported"));
                    boolean libInDifferentProject = path.startsWith("\\") || path.startsWith("/");
					if (libInDifferentProject)
                    {
                    	if (((onlyExportedLibs && isExported) || !onlyExportedLibs)) 
                   		{
                    		v.addElement(path.substring(1));
                   		}
                    }
                    else
                    {
                    	// lib in the same project
                    	if (((onlyExportedLibs && isExported) || !onlyExportedLibs) && !excludeLibsInProject)
                    	{
                    		v.addElement(project + "/" + path);
                    	}
                    }
                }
            }

            String s[] = new String[v.size()];
            return (String[]) v.toArray(s);
        }
        catch (NullPointerException e)
        {
            throw new BuildException(e);
        }
        catch (SAXException e)
        {
            throw new BuildException(e);
        }
        catch (IOException e)
        {
            throw new BuildException(new Exception("IOError opening " +  new File(cpfilePath).getAbsolutePath(), e));
        }
        catch (ParserConfigurationException e)
        {
            throw new BuildException(e);
        }
        catch (FactoryConfigurationError e)
        {
            throw new BuildException(e);
        }
    }

    public static String[] getDependProjects(String rootDir, String project, String excludeList)
            throws BuildException
    {
        try
        {
        	Vector exclude = listToVector(excludeList);
            String file = rootDir + File.separatorChar + project + File.separatorChar + ".classpath";
            if (!new File(file).exists()) 
            {
            	System.err.println("getDependProjects: file not found " + file);
            	return new String[0];
            }
			Element cpfile = XMLUtils.parseXmlFile(file);

            NodeList entries = cpfile.getElementsByTagName("classpathentry");
            int len = entries.getLength();
            Vector v = new Vector();
            for (int i = 0; i < len; i++)
            {
                Element element = (Element) entries.item(i);
                String kind = element.getAttribute("kind");
                String path = element.getAttribute("path");
                boolean isSrc = kind.equals("src");
                boolean startsWithSlash = (path.startsWith("/") || path.startsWith("\\"));
                if (isSrc && startsWithSlash && !exclude.contains(path))
                {
                    v.addElement(element.getAttribute("path").substring(1));
                }
            }
            String s[] = new String[v.size()];
            return (String[]) v.toArray(s);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            throw new BuildException(e);
        }
    }

    public static String[] getSourcePaths(String rootDir, String project, String excludeList)
            throws BuildException
    {
        try
        {
			String file = rootDir + File.separatorChar + project + File.separatorChar + ".classpath";
			if (!new File(file).exists())
			{
				System.err.println("getSourcePaths: file not found " + file);
				return new String[0];
			}
        	
        	Vector exclude = listToVector(excludeList);
            Element cpfile = XMLUtils.parseXmlFile(file);
            
            
            NodeList entries = cpfile.getElementsByTagName("classpathentry");
            int len = entries.getLength();
            Vector v = new Vector();
            for (int i = 0; i < len; i++)
            {
                Element element = (Element) entries.item(i);
                String kind = element.getAttribute("kind");
                String path = element.getAttribute("path");
                boolean isSrc = kind.equals("src");
                boolean startsWithSlash = (path.startsWith("/") || path
                        .startsWith("\\"));
                if (isSrc && !startsWithSlash && !exclude.contains(path))
                {
                    v.addElement(element.getAttribute("path"));
                }
            }
            String s[] = new String[v.size()];
            return (String[]) v.toArray(s);
        }
        catch (Exception e)
        {
            throw new BuildException(e);
        }
    }
    
    
	private static Vector listToVector(String list)
	{
		Vector v = new Vector();
		if (list != null)
		{
			StringTokenizer tok = new StringTokenizer(list, ",");
			while(tok.hasMoreElements())
			{
				v.addElement(tok.nextToken());
			}
		}
		return v;
	}    
}
