
package net.firefang.ant;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/**
 * @author omry
 */
public class XMLUtils
{
	public static Element parseXmlFile(String file) throws SAXException,
			IOException, ParserConfigurationException,
			FactoryConfigurationError
	{
		FileInputStream fis = null;

		try
		{
			fis = new FileInputStream(file);
			return parseXmlStream(fis);
		}
		finally
		{
			if(fis != null)
			{
				fis.close();
			}
		}
	}

	public static Element parseXmlStream(InputStream in)
			throws ParserConfigurationException, SAXException, IOException
	{
		return parseXmlStream(in, false);
	}

	public static Element parseXmlStream(InputStream in, boolean validating)
			throws ParserConfigurationException, SAXException, IOException
	{
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setValidating(validating);
		DocumentBuilder builder = factory.newDocumentBuilder();
		Document root = builder.parse(in);
		return root.getDocumentElement();
	}
}
