package net.firefang.ant.test;

import java.io.File;

import junit.framework.TestCase;
import net.firefang.ant.VirtualSymlinks;

import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;


/**
 * omry 
 * 12/11/2007
 */
public class VirtualSymlinksTest extends TestCase
{
	public void testLinks()
	{
		doTest("", "");
		String  base = new File("").getAbsolutePath().replace("\\", "/");
		doTest("src/net/firefang/ant/test/symlinks/", "src/net/firefang/ant/test/symlinks/");
		doTest("src/net/firefang/ant/test/symlinks/dir1/file", "src/net/firefang/ant/test/symlinks/dir2/file");
		doTest("src/net/firefang/ant/test/symlinks/dir1/dir3", "src/net/firefang/ant/test/symlinks/dir2");
		doTest(base + "/src/net/firefang/ant/test/symlinks/", base+ "/src/net/firefang/ant/test/symlinks/");
		doTest(base + "/src/net/firefang/ant/test/symlinks/dir1/file", base+ "/src/net/firefang/ant/test/symlinks/dir2/file");
		doTest(base + "/src/net/firefang/ant/test/symlinks/dir1/dir3", base+ "/src/net/firefang/ant/test/symlinks/dir2");
		doTest(base + "/src/net/firefang/ant/test/symlinks/file1", base+ "/src/net/firefang/ant/test/symlinks/file2");
	}

	private void doTest(String file, String expected)
	{
		VirtualSymlinks vs = new VirtualSymlinks();
		vs.setTaskName("Testing virtual symlinks");
		Project p = new Project();
		DefaultLogger defaultLogger = new DefaultLogger();
		defaultLogger.setMessageOutputLevel(Project.MSG_DEBUG);
		defaultLogger.setOutputPrintStream(System.out);
		p.addBuildListener(defaultLogger);
		
		vs.setProject(p);
		vs.setFile(file);
		vs.setResult("result");
		vs.execute();
		assertEquals(expected, p.getProperty("result"));
	}
}
